/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.routing;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.planx.xmlstore.routing.messaging.Streamable;

public class TimestampedValue
implements Streamable,
Serializable {
    private byte[] value;
    private long timestamp;

    public TimestampedValue(Serializable obj, long timestamp) throws IOException {
        this.timestamp = timestamp;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oout = new ObjectOutputStream(bout);
        oout.writeObject(obj);
        oout.close();
        this.value = bout.toByteArray();
    }

    public TimestampedValue(DataInput in) throws IOException {
        this.fromStream(in);
    }

    @Override
    public void fromStream(DataInput in) throws IOException {
        this.timestamp = in.readLong();
        this.value = new byte[in.readInt()];
        in.readFully(this.value);
    }

    @Override
    public void toStream(DataOutput out) throws IOException {
        out.writeLong(this.timestamp);
        out.writeInt(this.value.length);
        out.write(this.value);
    }

    public long timestamp() {
        return this.timestamp;
    }

    public byte[] getByteArray() {
        return this.value;
    }

    public Serializable getObject() throws IOException {
        try {
            ByteArrayInputStream bin = new ByteArrayInputStream(this.value);
            ObjectInputStream oin = new ObjectInputStream(bin);
            Serializable o = (Serializable)oin.readObject();
            oin.close();
            return o;
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e.toString());
        }
    }

    public String toString() {
        return "{timestamp=" + this.timestamp + ",value=" + this.value + "}";
    }
}

