/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.routing;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Random;
import org.planx.xmlstore.routing.messaging.Streamable;

public class Identifier
implements Streamable,
Serializable {
    private static final Random random = new Random();
    private BigInteger bigint;
    public static int IDSIZE = 128;

    public Identifier() {
        this.bigint = BigInteger.ZERO;
    }

    public Identifier(byte[] val) {
        this.bigint = new BigInteger(1, val);
        this.checkBounds();
    }

    public Identifier(BigInteger val) {
        this.bigint = val;
        this.checkBounds();
    }

    public Identifier(DataInput in) throws IOException {
        this.fromStream(in);
    }

    public static Identifier randomIdentifier() {
        Identifier id = new Identifier();
        id.bigint = new BigInteger(IDSIZE, random);
        return id;
    }

    private void checkBounds() {
        if (this.bigint.signum() < 0 || this.bigint.bitLength() > IDSIZE) {
            throw new IndexOutOfBoundsException("Value out of bounds: " + this.bigint.toString() + ", bitLength=" + this.bigint.bitLength());
        }
    }

    @Override
    public void fromStream(DataInput in) throws IOException {
        byte[] a = new byte[IDSIZE / 8];
        in.readFully(a);
        this.bigint = new BigInteger(1, a);
        this.checkBounds();
    }

    @Override
    public void toStream(DataOutput out) throws IOException {
        out.write(this.toByteArray());
    }

    public byte[] toByteArray() {
        int len = IDSIZE / 8;
        byte[] a = this.bigint.toByteArray();
        byte[] b = new byte[len];
        if (a.length == len + 1) {
            System.arraycopy(a, 1, b, len - a.length + 1, a.length - 1);
        } else if (a.length <= len) {
            System.arraycopy(a, 0, b, len - a.length, a.length);
        } else {
            throw new IndexOutOfBoundsException("length=" + (a.length - 1) + ", required=" + len);
        }
        return b;
    }

    public BigInteger value() {
        return this.bigint;
    }

    public boolean equals(Object o) {
        if (o instanceof Identifier) {
            return this.bigint.equals(((Identifier)o).bigint);
        }
        return false;
    }

    public int hashCode() {
        return this.bigint.hashCode();
    }

    public String toString() {
        return this.bigint.toString();
    }

    public String toBinary() {
        return Identifier.toBinary(this.bigint);
    }

    public static String toBinary(BigInteger val) {
        String s = val.toString(2);
        StringBuffer sb = new StringBuffer(IDSIZE);
        for (int i = 0; i < IDSIZE - s.length(); ++i) {
            sb.append('0');
        }
        sb.append(s);
        return sb.toString();
    }
}

