/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.planx.util.Array;
import org.planx.xmlstore.io.PolymorphicStreamer;
import org.planx.xmlstore.io.Streamer;

public final class Streamers {
    private static Map<Class, PolymorphicStreamer> pstreamers = new HashMap<Class, PolymorphicStreamer>();

    private Streamers() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E> PolymorphicStreamer<E> getPolymorphicStreamer(Class<E> cls) {
        Map<Class, PolymorphicStreamer> map = pstreamers;
        synchronized (map) {
            PolymorphicStreamer ps = pstreamers.get(cls);
            if (ps == null) {
                ps = new PolymorphicStreamer();
                pstreamers.put(cls, ps);
            }
            return ps;
        }
    }

    public static Streamer<String> stringStreamer() {
        return new Streamer<String>(){

            @Override
            public void toStream(DataOutput out, String s) throws IOException {
                Streamers.writeUTF(out, s);
            }

            @Override
            public String fromStream(DataInput in) throws IOException {
                return Streamers.readUTF(in);
            }
        };
    }

    public static int utfSize(String s) {
        int size = Streamers.rawUTFSize(s);
        return Streamers.shortIntSize(size) + size;
    }

    private static int rawUTFSize(String s) {
        int size = 0;
        int max = s.length();
        for (int i = 0; i < max; ++i) {
            char c = s.charAt(i);
            if (c == '\u0000') {
                size += 2;
                continue;
            }
            if (c <= '\u007f') {
                ++size;
                continue;
            }
            if (c <= '\u07ff') {
                size += 2;
                continue;
            }
            size += 3;
        }
        return size;
    }

    public static void writeUTF(DataOutput out, String s) throws IOException {
        int utflen = Streamers.rawUTFSize(s);
        Streamers.writeShortInt(out, utflen);
        Streamers.writeUTF(out, s, utflen);
    }

    public static void writeUTF(DataOutput out, String s, int utflen) throws IOException {
        char c;
        int i;
        int strlen = s.length();
        int count = 0;
        byte[] bytearr = new byte[utflen];
        for (i = 0; i < strlen && (c = s.charAt(i)) >= '\u0001' && c <= '\u007f'; ++i) {
            bytearr[count++] = (byte)c;
        }
        while (i < strlen) {
            c = s.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                bytearr[count++] = (byte)c;
            } else if (c > '\u07ff') {
                bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            } else {
                bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
            ++i;
        }
        out.write(bytearr, 0, utflen);
    }

    public static String readUTF(DataInput in) throws IOException {
        int utflen = Streamers.readShortInt(in);
        return Streamers.readUTF(in, utflen);
    }

    public static String readUTF(DataInput in, int utflen) throws IOException {
        int c;
        int count;
        byte[] bytearr = new byte[utflen];
        char[] chararr = new char[utflen];
        int chararr_count = 0;
        in.readFully(bytearr, 0, utflen);
        for (count = 0; count < utflen && (c = bytearr[count] & 0xFF) <= 127; ++count) {
            chararr[chararr_count++] = (char)c;
        }
        block6: while (count < utflen) {
            c = bytearr[count] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    chararr[chararr_count++] = (char)c;
                    continue block6;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + count);
                    }
                    chararr[chararr_count++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    continue block6;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 2];
                    byte char3 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + (count - 1));
                    }
                    chararr[chararr_count++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    continue block6;
                }
            }
            throw new UTFDataFormatException("malformed input around byte " + count);
        }
        return new String(chararr, 0, chararr_count);
    }

    public static <E> byte[] toByteArray(E obj, Streamer<E> streamer) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bout);
        streamer.toStream(out, obj);
        return bout.toByteArray();
    }

    public static <E> E fromByteArray(byte[] b, Streamer<E> streamer) throws IOException {
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(b));
        return streamer.fromStream(in);
    }

    public static int shortIntSize(int i) {
        return i < 128 ? 1 : 4;
    }

    public static void writeShortInt(DataOutput out, int i) throws IOException {
        if (i < 0) {
            throw new IllegalArgumentException("Integer may not be negative");
        }
        if (i < 128) {
            out.writeByte((byte)i);
        } else {
            out.writeInt(i | Integer.MIN_VALUE);
        }
    }

    public static int readShortInt(DataInput in) throws IOException {
        byte b0 = in.readByte();
        if (0 <= b0 && b0 < 128) {
            return b0;
        }
        byte b1 = in.readByte();
        byte b2 = in.readByte();
        byte b3 = in.readByte();
        return (b0 & 0x7F) << 24 | (b1 & 0xFF) << 16 | (b2 & 0xFF) << 8 | b3 & 0xFF;
    }

    public static void writePosArray(DataOutput out, int[] arr) throws IOException {
        Streamers.writeShortInt(out, arr.length);
        for (int i = 0; i < arr.length; ++i) {
            Streamers.writeShortInt(out, arr[i]);
        }
    }

    public static int[] readPosArray(DataInput in) throws IOException {
        int size = Streamers.readShortInt(in);
        int[] arr = new int[size];
        for (int i = 0; i < size; ++i) {
            arr[i] = Streamers.readShortInt(in);
        }
        return arr;
    }

    public static <E> void writeList(DataOutput out, List<E> l, Streamer<E> s) throws IOException {
        Streamers.writeShortInt(out, l.size());
        for (E elm : l) {
            s.toStream(out, elm);
        }
    }

    public static <E> List<E> readList(DataInput in, Streamer<E> s) throws IOException {
        int size = Streamers.readShortInt(in);
        Object[] ss = new Object[size];
        for (int i = 0; i < size; ++i) {
            ss[i] = s.fromStream(in);
        }
        return Array.asUnmodifiableList(ss);
    }

    public static boolean wrapNull(DataOutput out, Object o) throws IOException {
        if (o == null) {
            out.writeBoolean(false);
            return false;
        }
        out.writeBoolean(true);
        return true;
    }

    public static boolean unwrapNull(DataInput in) throws IOException {
        return in.readBoolean();
    }
}

