/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.io;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.planx.xmlstore.io.ByteOutputStream;
import org.planx.xmlstore.io.FileSystem;
import org.planx.xmlstore.io.FileSystemIdentifier;
import org.planx.xmlstore.io.LocalLocator;
import org.planx.xmlstore.io.UnknownLocatorException;

public class MemoryFileSystem
implements FileSystem {
    private FileSystemIdentifier fsi;
    private ByteOutputStream bout;
    private DataOutputStream out;

    public MemoryFileSystem() {
        this(1024);
    }

    public MemoryFileSystem(int capacity) {
        this(capacity, new FileSystemIdentifier());
    }

    public MemoryFileSystem(int capacity, FileSystemIdentifier fsi) {
        this.fsi = fsi;
        this.bout = new ByteOutputStream(capacity);
        this.out = new DataOutputStream(this.bout);
    }

    @Override
    public FileSystemIdentifier currentIdentifier() {
        return this.fsi;
    }

    @Override
    public LocalLocator allocate() throws IOException {
        return new LocalLocator(this.bout.size(), 0, this.fsi);
    }

    @Override
    public LocalLocator allocate(int size) throws IOException {
        return new LocalLocator(this.bout.size(), size, this.fsi);
    }

    @Override
    public LocalLocator allocate(int size, FileSystemIdentifier id) throws IOException {
        if (!this.fsi.equals(id)) {
            throw new IllegalArgumentException("FileSystemIdentifier not accepted " + id + " must be " + this.fsi);
        }
        return this.allocate(size);
    }

    @Override
    public LocalLocator all() {
        return new LocalLocator(0, this.bout.size(), this.fsi);
    }

    @Override
    public void free(LocalLocator loc) throws IOException, UnknownLocatorException {
        this.checkLocator(loc);
    }

    public void clear() {
        this.clear(new FileSystemIdentifier());
    }

    public void clear(FileSystemIdentifier fsi) {
        this.bout.reset();
        this.fsi = fsi;
    }

    @Override
    public DataInput getInput(LocalLocator l) throws IOException, UnknownLocatorException {
        this.checkLocator(l);
        byte[] buf = this.bout.toByteArray();
        ByteArrayInputStream bin = new ByteArrayInputStream(buf, l.getOff(), buf.length - l.getOff());
        return new DataInputStream(bin);
    }

    @Override
    public DataOutput getOutput(LocalLocator l) throws IOException, UnknownLocatorException {
        this.checkLocator(l);
        if (l.getOff() != this.bout.size()) {
            throw new IOException("Only append allowed. LocalLocator offset " + l.getOff() + ", expected " + this.bout.size());
        }
        return this.out;
    }

    @Override
    public void copy(FileSystem fs, LocalLocator fromLoc, LocalLocator locTo) throws IOException, UnknownLocatorException {
        this.checkLocator(locTo);
        if (locTo.getOff() != this.bout.size()) {
            throw new IOException("Only appending allowed, toLoc=" + locTo + ", expected offset " + this.bout.size());
        }
        DataInput in = fs.getInput(fromLoc);
        this.bout.copy(in, fromLoc.getLen());
    }

    @Override
    public long size() throws IOException {
        return this.bout.size();
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public boolean isContained(LocalLocator l) {
        if (l == null) {
            return false;
        }
        return this.fsi.equals(l.getFileSystemId());
    }

    private void checkLocator(LocalLocator l) throws UnknownLocatorException {
        if (!this.fsi.equals(l.getFileSystemId())) {
            throw new UnknownLocatorException("LocalLocator does not originate from this FileSystem");
        }
    }
}

