/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.planx.msd.Discriminator;
import org.planx.msd.DiscriminatorFactory;
import org.planx.msd.Discriminators;
import org.planx.msd.Extractor;
import org.planx.msd.Memory;
import org.planx.msd.array.ByteArrayDiscriminator;
import org.planx.msd.lang.PolymorphicDiscriminator;
import org.planx.msd.number.IntegerDiscriminator;
import org.planx.msd.util.AbstractDiscriminator;
import org.planx.xmlstore.Reference;
import org.planx.xmlstore.io.FileSystemIdentifier;
import org.planx.xmlstore.io.PolymorphicStreamer;
import org.planx.xmlstore.io.Streamer;
import org.planx.xmlstore.io.Streamers;
import org.planx.xmlstore.references.Locator;

public class LocalLocator
implements Locator,
Comparable<LocalLocator> {
    public static final byte CLASS_ID = 1;
    private static Streamer<LocalLocator> compactStreamer = new LocatorStreamer(true);
    private static Streamer<LocalLocator> locatorStreamer = new LocatorStreamer(false);
    protected int off;
    protected int len;
    protected FileSystemIdentifier fsi;
    protected LocalLocator eqref = null;

    public LocalLocator(int off, int len, FileSystemIdentifier fsi) {
        if (off < 0) {
            throw new IllegalArgumentException("Negative off");
        }
        this.off = off;
        this.len = len;
        this.fsi = fsi;
    }

    private LocalLocator() {
    }

    public LocalLocator clone() {
        LocalLocator l = new LocalLocator();
        l.off = this.getOff();
        l.len = this.getLen();
        l.fsi = this.getFileSystemId();
        return l;
    }

    protected LocalLocator find() {
        if (this.eqref == null) {
            return this;
        }
        this.eqref = this.eqref.find();
        return this.eqref;
    }

    public FileSystemIdentifier getFileSystemId() {
        return this.find().fsi;
    }

    public void setFileSystemId(FileSystemIdentifier fsi) {
        this.find().fsi = fsi;
    }

    public void locatorMoved(LocalLocator loc) {
        if (loc == this) {
            return;
        }
        this.eqref = loc;
        this.fsi = null;
    }

    public int getOff() {
        return this.find().off;
    }

    void setOff(int off) {
        this.find().off = off;
    }

    public int getLen() {
        return this.find().len;
    }

    void setLen(int len) {
        this.find().len = len;
    }

    public boolean isContained(LocalLocator l) {
        int off2;
        if (l == null) {
            return false;
        }
        int off1 = this.getOff();
        return off1 <= (off2 = l.getOff()) && off2 + l.getLen() <= off1 + this.getLen() && this.getFileSystemId().equals(l.getFileSystemId());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LocalLocator)) {
            return false;
        }
        LocalLocator loc = (LocalLocator)o;
        return this.getOff() == loc.getOff() && this.getFileSystemId().equals(loc.getFileSystemId());
    }

    public int hashCode() {
        return this.getOff() ^ this.getFileSystemId().hashCode();
    }

    @Override
    public int compareTo(LocalLocator loc) {
        return this.getOff() - loc.getOff();
    }

    public String toString() {
        FileSystemIdentifier fsi = this.getFileSystemId();
        return "" + (fsi == null ? "null" : fsi) + ":" + this.getOff() + "," + this.getLen();
    }

    public static Streamer<LocalLocator> getStreamer(boolean isCompact) {
        return isCompact ? compactStreamer : locatorStreamer;
    }

    public static Discriminator<LocalLocator> getDiscriminator(Memory memory) {
        return new LocatorDiscriminator(memory);
    }

    static {
        PolymorphicStreamer<Reference> ps = Streamers.getPolymorphicStreamer(Reference.class);
        ps.addStreamer((byte)1, LocalLocator.class, locatorStreamer);
        DiscriminatorFactory factory = DiscriminatorFactory.instance();
        PolymorphicDiscriminator<Reference> pd = factory.getPolymorphicDiscriminator(Reference.class);
        pd.addDiscriminator(LocalLocator.class, LocalLocator.getDiscriminator(factory.getMemory()));
    }

    private static class LocatorDiscriminator
    extends AbstractDiscriminator<LocalLocator> {
        private Discriminator<Integer> offDisc;
        private Discriminator<byte[]> fsiDisc;

        public LocatorDiscriminator(Memory memory) {
            this.offDisc = new IntegerDiscriminator(memory);
            this.fsiDisc = new ByteArrayDiscriminator(memory);
        }

        @Override
        public <U, S> Collection<List<S>> discriminate(List<? extends U> values, final Extractor<U, ? extends LocalLocator, S> e) {
            Extractor e1 = new Extractor<U, Integer, U>(){

                @Override
                public Integer getLabel(U elm) {
                    return ((LocalLocator)e.getLabel(elm)).getOff();
                }

                @Override
                public U getValue(U elm) {
                    return elm;
                }
            };
            Extractor e2 = new Extractor<U, byte[], S>(){

                @Override
                public byte[] getLabel(U elm) {
                    return ((LocalLocator)e.getLabel(elm)).getFileSystemId().internal();
                }

                @Override
                public S getValue(U elm) {
                    return e.getValue(elm);
                }
            };
            return Discriminators.discriminate(values, this.offDisc, e1, this.fsiDisc, e2);
        }
    }

    private static class LocatorStreamer
    implements Streamer<LocalLocator> {
        private static Streamer<FileSystemIdentifier> fsiStreamer = FileSystemIdentifier.getStreamer();
        private boolean isCompact = false;

        LocatorStreamer(boolean isCompact) {
            this.isCompact = isCompact;
        }

        @Override
        public void toStream(DataOutput out, LocalLocator l) throws IOException {
            Streamers.writeShortInt(out, l.getOff());
            if (!this.isCompact) {
                Streamers.writeShortInt(out, l.getLen());
                fsiStreamer.toStream(out, l.getFileSystemId());
            }
        }

        @Override
        public LocalLocator fromStream(DataInput in) throws IOException {
            int off = Streamers.readShortInt(in);
            int len = this.isCompact ? 0 : Streamers.readShortInt(in);
            FileSystemIdentifier locFsi = this.isCompact ? null : fsiStreamer.fromStream(in);
            return new LocalLocator(off, len, locFsi);
        }
    }
}

