/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.io;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.SortedSet;
import java.util.TreeSet;
import org.planx.xmlstore.io.FileSystem;
import org.planx.xmlstore.io.FileSystemIdentifier;
import org.planx.xmlstore.io.LocalLocator;
import org.planx.xmlstore.io.Streamer;
import org.planx.xmlstore.io.UnknownLocatorException;

public class LocalFileSystem
implements FileSystem {
    private static final int BUFFER_SIZE = 131072;
    private byte[] buffer = new byte[131072];
    private String name;
    private RandomAccessFile diskw;
    private RandomAccessFile diskr;
    private FileSystemIdentifier fsi;
    private SortedSet<LocalLocator> usedList;
    private LocalLocator pointer = null;

    public LocalFileSystem(String name) throws IOException {
        this.name = name;
        this.fsi = new FileSystemIdentifier();
        this.diskw = new RandomAccessFile(name, "rw");
        this.diskr = new RandomAccessFile(name, "r");
        this.usedList = new TreeSet<LocalLocator>();
        this.readUsedList();
    }

    @Override
    public FileSystemIdentifier currentIdentifier() {
        return new FileSystemIdentifier();
    }

    @Override
    public long size() throws IOException {
        return this.diskw.length();
    }

    @Override
    public void close() throws IOException {
        this.writeUsedList();
        this.diskw.close();
        this.diskr.close();
    }

    @Override
    public void copy(FileSystem fs, LocalLocator fromLoc, LocalLocator locTo) throws IOException, UnknownLocatorException {
        int s;
        this.checkLocator(locTo);
        if (locTo.getLen() < fromLoc.getLen()) {
            throw new IOException("Not enough space at " + locTo + " to contain " + fromLoc);
        }
        this.diskw.seek(locTo.getOff());
        int off = (int)this.diskw.getFilePointer();
        DataInput in = fs.getInput(fromLoc);
        for (int remain = fromLoc.getLen(); remain > 0; remain -= s) {
            s = remain > 131072 ? 131072 : remain;
            in.readFully(this.buffer, 0, s);
            this.diskw.write(this.buffer, 0, s);
        }
        int len = (int)this.diskw.getFilePointer() - off;
        if (len != fromLoc.getLen()) {
            throw new IOException("Size " + fromLoc.getLen() + " in argument " + "does not match copied bytes: " + len);
        }
    }

    @Override
    public DataInput getInput(LocalLocator l) throws IOException, UnknownLocatorException {
        this.checkLocator(l);
        this.diskr.seek(l.getOff());
        return this.diskr;
    }

    @Override
    public DataOutput getOutput(LocalLocator l) throws IOException, UnknownLocatorException {
        this.checkLocator(l);
        this.diskw.seek(l.getOff());
        return this.diskw;
    }

    @Override
    public LocalLocator all() throws IOException {
        return new LocalLocator(0, (int)this.diskw.length(), this.fsi);
    }

    @Override
    public LocalLocator allocate() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public LocalLocator allocate(int size) throws IOException {
        return this.allocate(size, this.fsi);
    }

    @Override
    public LocalLocator allocate(int size, FileSystemIdentifier id) throws IOException {
        LocalLocator loc = null;
        if (!this.usedList.isEmpty()) {
            if (this.pointer == null) {
                this.pointer = this.usedList.first();
            }
            LocalLocator start = this.pointer;
            loc = this.findFreeSpace(size, this.pointer, id);
            if (loc == null) {
                this.pointer = this.usedList.first();
                if (start.compareTo(this.pointer) > 0) {
                    loc = this.findFreeSpace(size, null, id);
                }
            }
        }
        if (loc == null) {
            if (!this.usedList.isEmpty()) {
                LocalLocator last = this.usedList.last();
                loc = new LocalLocator(last.getOff() + last.getLen(), size, id);
                if (last.getFileSystemId().equals(id)) {
                    last.setLen(last.getLen() + size);
                } else {
                    this.usedList.add(new LocalLocator(last.getOff() + last.getLen(), size, id));
                }
            } else {
                loc = new LocalLocator((int)this.diskw.length(), size, id);
                this.usedList.add(new LocalLocator((int)this.diskw.length(), size, id));
            }
        }
        return loc;
    }

    private LocalLocator findFreeSpace(int size, LocalLocator prev, FileSystemIdentifier id) {
        SortedSet<LocalLocator> tailSet = this.usedList.tailSet(this.pointer);
        for (LocalLocator loc : tailSet) {
            if (loc == prev) continue;
            this.pointer = loc;
            int gap_off = prev == null ? 0 : prev.getOff() + prev.getLen();
            int gap_len = loc.getOff() - gap_off;
            if (gap_len < 0) {
                throw new IllegalStateException("LocalLocator " + prev + " extends into " + loc);
            }
            if (gap_len >= size) {
                if (prev != null && prev.getFileSystemId().equals(id)) {
                    if (gap_len == size && loc.getFileSystemId().equals(id)) {
                        prev.setLen(prev.getLen() + size + loc.getLen());
                    } else {
                        prev.setLen(prev.getLen() + size);
                    }
                } else if (gap_len == size && loc.getFileSystemId().equals(id)) {
                    loc.setOff(gap_off);
                    loc.setLen(size + loc.getLen());
                } else {
                    this.usedList.add(new LocalLocator(gap_off, size, id));
                }
                return new LocalLocator(gap_off, size, id);
            }
            prev = loc;
        }
        return null;
    }

    @Override
    public void free(LocalLocator l) throws IOException, UnknownLocatorException {
        LocalLocator inLoc = this.checkLocator(l);
        int off = l.getOff();
        int len = l.getLen();
        int ioff = inLoc.getOff();
        int ilen = inLoc.getLen();
        if (ioff == off && len == ilen) {
            this.usedList.remove(inLoc);
        } else if (ioff == off && len < ilen) {
            inLoc.setOff(off + len);
            inLoc.setLen(ilen - len);
        } else if (ioff < off && off + len == ioff + ilen) {
            inLoc.setLen(off - ioff);
        } else if (ioff < off && off + len < ioff + ilen) {
            LocalLocator nloc = new LocalLocator(off + len, ioff + ilen - (off + len), inLoc.getFileSystemId());
            inLoc.setLen(off - ioff);
            this.usedList.add(nloc);
        } else {
            throw new IllegalArgumentException("LocalLocator " + l + " is not completely contained " + "in block " + inLoc);
        }
        this.truncate();
        this.fsi = new FileSystemIdentifier();
    }

    private void truncate() throws IOException {
        if (!this.usedList.isEmpty()) {
            LocalLocator loc = this.usedList.last();
            int end = loc.getOff() + loc.getLen();
            if (this.diskw.length() > (long)end) {
                this.diskw.setLength(end);
            }
        } else {
            this.diskw.setLength(0L);
        }
    }

    @Override
    public boolean isContained(LocalLocator loc) {
        try {
            this.checkLocator(loc);
            return true;
        }
        catch (UnknownLocatorException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    private LocalLocator checkLocator(LocalLocator l) throws IOException, UnknownLocatorException {
        SortedSet<LocalLocator> headSet;
        int off = l.getOff();
        int len = l.getLen();
        LocalLocator inLoc = null;
        SortedSet<LocalLocator> tailSet = this.usedList.tailSet(l);
        if (!tailSet.isEmpty() && (inLoc = tailSet.first()).getOff() != off) {
            inLoc = null;
        }
        if (inLoc == null && !(headSet = this.usedList.headSet(l)).isEmpty()) {
            inLoc = headSet.last();
        }
        if (inLoc == null) {
            throw new IllegalArgumentException("No encapsulating locator for " + l);
        }
        if (!inLoc.getFileSystemId().equals(l.getFileSystemId())) {
            throw new IllegalArgumentException("Mismatching IDs in argument " + l + " and " + "encapsulating locator " + inLoc);
        }
        int ioff = inLoc.getOff();
        int ilen = inLoc.getLen();
        if (ioff <= off && off + len <= ioff + ilen) {
            return inLoc;
        }
        throw new IllegalArgumentException("Misalignment of argument " + l + " in relation to encapsulating locator " + inLoc);
    }

    private void writeUsedList() throws IOException {
        Streamer<LocalLocator> locStreamer = LocalLocator.getStreamer(false);
        DataOutputStream out = new DataOutputStream(new FileOutputStream(this.name + ".free"));
        out.writeInt(this.usedList.size());
        for (LocalLocator loc : this.usedList) {
            locStreamer.toStream(out, loc);
        }
        out.flush();
        out.close();
    }

    private void readUsedList() throws IOException {
        try {
            Streamer<LocalLocator> locStreamer = LocalLocator.getStreamer(false);
            DataInputStream in = new DataInputStream(new FileInputStream(this.name + ".free"));
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                LocalLocator loc = locStreamer.fromStream(in);
                this.usedList.add(loc);
            }
            in.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public String toString() {
        return "fsi=" + this.fsi.toString() + ", usedList=" + this.usedList;
    }
}

