/*
 * Decompiled with CFR 0.152.
 */
package org.planx.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.List;
import java.util.RandomAccess;

public class UnmodifiableArrayList<E>
extends AbstractList<E>
implements RandomAccess,
Serializable {
    private E[] a;

    public UnmodifiableArrayList(List<E> list) {
        this(list.toArray());
    }

    public UnmodifiableArrayList(E[] array) {
        if (array == null) {
            throw new NullPointerException();
        }
        this.a = array;
    }

    public E[] internal() {
        return this.a;
    }

    @Override
    public int size() {
        return this.a.length;
    }

    @Override
    public E get(int index) {
        return this.a[index];
    }

    @Override
    public int indexOf(Object o) {
        if (o == null) {
            for (int i = 0; i < this.a.length; ++i) {
                if (this.a[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.a.length; ++i) {
                if (!o.equals(this.a[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.a.length];
        System.arraycopy(this.a, 0, result, 0, this.a.length);
        return result;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        if (array.length < this.a.length) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), this.a.length);
        }
        System.arraycopy(this.a, 0, array, 0, this.a.length);
        if (array.length > this.a.length) {
            array[this.a.length] = null;
        }
        return array;
    }
}

