/*
 * Decompiled with CFR 0.152.
 */
package org.planx.msd.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.planx.msd.Discriminator;
import org.planx.msd.Extractor;
import org.planx.msd.Memory;
import org.planx.msd.number.IntExtractor;
import org.planx.msd.number.IntegerDiscriminator;
import org.planx.msd.util.AbstractDiscriminator;
import org.planx.util.Array;
import org.planx.util.Association;
import org.planx.util.Pair;
import org.planx.util.Pairs;

public class IterationListDiscriminator<T>
extends AbstractDiscriminator<List<T>> {
    private static final int INIT_CAPACITY = 10;
    private Discriminator<T> disc;
    private IntegerDiscriminator intDisc;

    public IterationListDiscriminator(Discriminator<T> d, Memory memory) {
        this.disc = d;
        this.intDisc = new IntegerDiscriminator(memory);
    }

    @Override
    public <U, S> Collection<List<S>> discriminate(List<? extends U> values, final Extractor<U, ? extends List<T>, S> e) {
        if (values.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<List<S>> result = new ArrayList<List<S>>();
        CurrentExtractor ext = new CurrentExtractor();
        List[] work = new List[10];
        int work_capacity = 10;
        int work_head = 0;
        IntExtractor intExt = new IntExtractor<U, Pair<CurrentIterator<T>, S>>(){

            @Override
            public int getLabel(U elm) {
                return ((List)e.getLabel(elm)).size();
            }

            @Override
            public Pair<CurrentIterator<T>, S> getValue(U elm) {
                List list = (List)e.getLabel(elm);
                CurrentIterator it = new CurrentIterator(list.iterator());
                return new Association(it, e.getValue(elm));
            }
        };
        Collection partition = this.intDisc.discriminate(values, intExt);
        for (List block : partition) {
            if (block.size() > 1) {
                if (work_head + 1 >= work_capacity) {
                    work = Array.ensureCapacity(work, work_head, work_capacity + 1);
                    work_capacity = work.length;
                }
                work[work_head] = block;
                ++work_head;
                continue;
            }
            result.add(Pairs.retainSecond(block));
        }
        while (work_head > 0) {
            if (work_head < work_capacity) {
                work[work_head] = null;
            }
            List block = work[--work_head];
            int blockSize = block.size();
            if (((CurrentIterator)((Pair)block.get(0)).getFirst()).hasNext()) {
                for (Pair pair : block) {
                    ((CurrentIterator)pair.getFirst()).next();
                }
                partition = this.disc.discriminate(block, ext);
                for (List list : partition) {
                    if (list.size() > 1) {
                        if (work_head + 1 >= work_capacity) {
                            work = Array.ensureCapacity(work, work_head, work_capacity + 1);
                            work_capacity = work.length;
                        }
                        work[work_head] = list;
                        ++work_head;
                        continue;
                    }
                    result.add(Pairs.retainSecond(list));
                }
                continue;
            }
            result.add(Pairs.retainSecond(block));
        }
        return result;
    }

    private static class CurrentExtractor<E, F>
    implements Extractor<Pair<CurrentIterator<E>, F>, E, Pair<CurrentIterator<E>, F>> {
        private CurrentExtractor() {
        }

        @Override
        public E getLabel(Pair<CurrentIterator<E>, F> elm) {
            return elm.getFirst().current;
        }

        @Override
        public Pair<CurrentIterator<E>, F> getValue(Pair<CurrentIterator<E>, F> elm) {
            return elm;
        }
    }

    private static class CurrentIterator<E>
    implements Iterator<E> {
        Iterator<E> it;
        E current = null;

        public CurrentIterator(Iterator<E> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public E next() {
            this.current = this.it.next();
            return this.current;
        }

        public E current() {
            return this.current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

