/*
 * Decompiled with CFR 0.152.
 */
package org.planx.msd.lang;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.planx.msd.Discriminator;
import org.planx.msd.Extractor;
import org.planx.msd.lang.NonDiscriminableObjectException;
import org.planx.msd.util.AbstractDiscriminator;

public class PolymorphicDiscriminator<T>
extends AbstractDiscriminator<T> {
    private List<Entry<? extends T>> ds = new ArrayList<Entry<? extends T>>();

    public <E extends T> void addDiscriminator(Class<E> cls, Discriminator<? super E> d) {
        this.ds.add(new Entry<E>(cls, d));
    }

    @Override
    public <U, S> Collection<List<S>> discriminate(List<? extends U> values, Extractor<U, ? extends T, S> e) {
        if (values.isEmpty()) {
            return Collections.emptyList();
        }
        int size = this.ds.size();
        List[] svs = new List[size];
        for (U elm : values) {
            int i = 0;
            for (Entry<? extends T> entry : this.ds) {
                if (entry.cls.isInstance(e.getLabel(elm))) {
                    ArrayList<U> vs = svs[i];
                    if (vs == null) {
                        svs[i] = vs = new ArrayList<U>();
                    }
                    vs.add(elm);
                    break;
                }
                ++i;
            }
            if (i < size) continue;
            throw new NonDiscriminableObjectException("No Discriminator registered for " + e.getLabel(elm).getClass());
        }
        ArrayList<List<S>> result = new ArrayList<List<S>>();
        int j = 0;
        for (Entry<? extends T> entry : this.ds) {
            List list;
            if ((list = svs[j++]) == null) continue;
            Collection<List<S>> es = entry.d.discriminate(list, e);
            result.addAll(es);
        }
        return result;
    }

    private static class Entry<E> {
        Class<E> cls;
        Discriminator<? super E> d;

        public Entry(Class<E> cls, Discriminator<? super E> d) {
            this.cls = cls;
            this.d = d;
        }
    }
}

