/*
 * Decompiled with CFR 0.152.
 */
package org.planx.msd.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.planx.msd.Discriminator;
import org.planx.msd.Discriminators;
import org.planx.msd.Extractor;
import org.planx.msd.graph.Navigator;
import org.planx.util.Association;
import org.planx.util.Pair;

public class Compactor<N> {
    protected Navigator<N> nav = null;
    protected Discriminator<N> disc = null;
    protected boolean doStat = false;
    protected int inputNumOfNodes = 0;
    protected int inputShareDegree = 0;
    protected int outputNumOfNodes = 0;
    protected int merges = 0;

    protected Compactor() {
    }

    public Compactor(Navigator<N> nav, Discriminator<N> d) {
        this(nav, d, false);
    }

    public Compactor(Navigator<N> nav, Discriminator<N> d, boolean doStatistics) {
        this.nav = nav;
        this.disc = d;
        this.doStat = doStatistics;
    }

    public void share(N root) {
        if (this.doStat) {
            this.clearStatistics();
        }
        List<List<Pair<N, Edge>>> groups = this.heightDiscriminate(root);
        for (List<Pair<N, Edge>> group : groups) {
            Extractor e = Discriminators.pairExtractor();
            Collection eqClasses = this.disc.discriminate(group, e);
            for (List<Edge> list : eqClasses) {
                if (this.doStat) {
                    ++this.outputNumOfNodes;
                }
                if (list.size() == 1) continue;
                N canon = this.nav.chooseCanonical(list);
                if (canon == null) {
                    throw new NullPointerException("Must choose canonical node");
                }
                for (Edge loc : list) {
                    N current;
                    Object parent = loc.parent;
                    if (canon == loc.node || parent == null) continue;
                    if (this.doStat && canon != (current = this.nav.getChild(parent, loc.childIndex))) {
                        ++this.merges;
                    }
                    this.nav.setChild(parent, loc.childIndex, canon);
                }
            }
        }
    }

    private List<List<Pair<N, Edge>>> heightDiscriminate(N node) {
        ArrayList<List<Pair<N, Edge>>> groups = new ArrayList<List<Pair<N, Edge>>>();
        this.visitDepthFirst(node, null, 0, new Object(), groups);
        return groups;
    }

    private int visitDepthFirst(N node, N parent, int childIndex, Object visitToken, List<List<Pair<N, Edge>>> groups) {
        int height = -1;
        if (this.nav.getVisitToken(node) == visitToken) {
            height = this.nav.getHeight(node);
            this.visit(node, parent, childIndex, height, groups);
            if (this.doStat) {
                ++this.inputShareDegree;
            }
            return height;
        }
        this.nav.setVisitToken(node, visitToken);
        if (this.doStat) {
            ++this.inputNumOfNodes;
        }
        int max = this.nav.childCount(node);
        for (int i = 0; i < max; ++i) {
            int h;
            N child = this.nav.getChild(node, i);
            int n = h = this.nav.isOutside(child) ? 0 : this.visitDepthFirst(child, node, i, visitToken, groups);
            if (h <= height) continue;
            height = h;
        }
        this.visit(node, parent, childIndex, ++height, groups);
        this.nav.setHeight(node, height);
        return height;
    }

    private void visit(N node, N parent, int childIndex, int height, List<List<Pair<N, Edge>>> groups) {
        while (groups.size() <= height) {
            groups.add(new ArrayList());
        }
        Edge loc = new Edge(node, parent, childIndex);
        groups.get(height).add(new Association<N, Edge>(node, loc));
    }

    protected void clearStatistics() {
        this.inputNumOfNodes = 0;
        this.inputShareDegree = 0;
        this.outputNumOfNodes = 0;
        this.merges = 0;
    }

    public Statistics getStatistics() {
        return new Statistics(this);
    }

    public static class Statistics {
        public int inputNumOfNodes;
        public int inputShareDegree;
        public int outputNumOfNodes;
        public int outputShareDegree;
        public int merges;

        Statistics(Compactor c) {
            this.inputNumOfNodes = c.inputNumOfNodes;
            this.inputShareDegree = c.inputShareDegree;
            this.outputNumOfNodes = c.outputNumOfNodes;
            this.merges = c.merges;
        }

        public String toString() {
            return "Compactor{in=" + this.inputNumOfNodes + ",shared=" + this.inputShareDegree + ",out=" + this.outputNumOfNodes + ",merges=" + this.merges + "}";
        }
    }

    public class Edge {
        public N node;
        public N parent;
        public int childIndex;

        Edge(N node, N parent, int childIndex) {
            this.node = node;
            this.parent = parent;
            this.childIndex = childIndex;
        }

        public String toString() {
            String s1 = this.node == null ? "null" : this.node.toString();
            String s2 = this.parent == null ? "null" : this.parent.toString();
            return "{" + s1 + "," + s2 + "," + this.childIndex + "}";
        }
    }
}

