/*
 * Decompiled with CFR 0.152.
 */
package org.planx.msd.character;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;
import org.planx.msd.Discriminators;
import org.planx.msd.Extractor;
import org.planx.msd.Memory;
import org.planx.msd.util.AbstractDiscriminator;
import org.planx.util.Array;

public class LexicographicCharSequenceDiscriminator<T extends CharSequence>
extends AbstractDiscriminator<T> {
    private static final int INIT_CAPACITY = 10;
    private Memory memory;

    public LexicographicCharSequenceDiscriminator(Memory memory) {
        this.memory = memory;
    }

    @Override
    public <U, S> Collection<List<S>> discriminate(List<? extends U> values, Extractor<U, ? extends T, S> e) {
        int vsize = values.size();
        switch (vsize) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                List<S> l = Collections.singletonList(e.getValue(values.get(0)));
                return Collections.singletonList(l);
            }
        }
        if (!(values instanceof RandomAccess)) {
            values = new ArrayList<U>(values);
        }
        List[] dictionary = this.memory.dictionary;
        ArrayList<List<S>> result = new ArrayList<List<S>>();
        ArrayList<S> finished = new ArrayList<S>();
        int[] indexes = new int[10];
        List[] work = new List[10];
        int work_capacity = 10;
        int work_head = 1;
        work[0] = values;
        while (work_head > 0) {
            List block;
            int blockSize;
            if (work_head < work_capacity) {
                work[work_head] = null;
            }
            if ((blockSize = (block = work[--work_head]).size()) == 1) {
                result.add(Discriminators.valueList(block, e));
                continue;
            }
            int initSubSize = blockSize < 10 ? blockSize : 10;
            int index = indexes[work_head];
            char c = Integer.MAX_VALUE;
            char max_used = '\u0000';
            for (int i = 0; i < blockSize; ++i) {
                ArrayList list;
                Object elm = block.get(i);
                CharSequence seq = (CharSequence)e.getLabel(elm);
                if (seq.length() <= index) {
                    finished.add(e.getValue(elm));
                    continue;
                }
                char c2 = seq.charAt(index);
                if (c2 > max_used) {
                    max_used = c2;
                }
                if (c2 < c) {
                    c = c2;
                }
                if ((list = dictionary[c2]) == null) {
                    dictionary[c2] = list = new ArrayList(initSubSize);
                }
                list.add(elm);
            }
            if (!finished.isEmpty()) {
                result.add(finished);
                finished = new ArrayList();
            }
            ++index;
            for (char idx = max_used; idx >= c; --idx) {
                List subBlock = dictionary[idx];
                if (subBlock == null) continue;
                dictionary[idx] = null;
                if (work_head + 1 >= work_capacity) {
                    work = Array.ensureCapacity(work, work_head, work_capacity + 1);
                    indexes = Array.ensureCapacity(indexes, work_head, work_capacity + 1);
                    work_capacity = work.length;
                }
                work[work_head] = subBlock;
                indexes[work_head] = index;
                ++work_head;
            }
        }
        return result;
    }

    public void sort(List<T> values) {
        int vsize = values.size();
        if (vsize <= 1) {
            return;
        }
        List[] dictionary = this.memory.dictionary;
        int[] indexes = new int[10];
        List[] work = new List[10];
        int work_capacity = 10;
        int work_head = 1;
        work[0] = values;
        int cursor = 0;
        while (work_head > 0) {
            List block;
            int blockSize;
            if (work_head < work_capacity) {
                work[work_head] = null;
            }
            if ((blockSize = (block = work[--work_head]).size()) == 1) {
                values.set(cursor++, block.get(0));
                continue;
            }
            int initSubSize = blockSize < 10 ? blockSize : 10;
            int index = indexes[work_head];
            char c = Integer.MAX_VALUE;
            char max_used = '\u0000';
            for (int i = 0; i < blockSize; ++i) {
                ArrayList<CharSequence> list;
                CharSequence seq = (CharSequence)block.get(i);
                if (seq.length() <= index) {
                    values.set(cursor++, seq);
                    continue;
                }
                char c2 = seq.charAt(index);
                if (c2 > max_used) {
                    max_used = c2;
                }
                if (c2 < c) {
                    c = c2;
                }
                if ((list = dictionary[c2]) == null) {
                    dictionary[c2] = list = new ArrayList<CharSequence>(initSubSize);
                }
                list.add(seq);
            }
            ++index;
            for (char idx = max_used; idx >= c; --idx) {
                List subBlock = dictionary[idx];
                if (subBlock == null) continue;
                dictionary[idx] = null;
                if (work_head + 1 >= work_capacity) {
                    work = Array.ensureCapacity(work, work_head, work_capacity + 1);
                    indexes = Array.ensureCapacity(indexes, work_head, work_capacity + 1);
                    work_capacity = work.length;
                }
                work[work_head] = subBlock;
                indexes[work_head] = index;
                ++work_head;
            }
        }
    }
}

