/*
 * Decompiled with CFR 0.152.
 */
package org.planx.msd.array;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;
import org.planx.msd.Discriminators;
import org.planx.msd.Extractor;
import org.planx.msd.Memory;
import org.planx.msd.util.AbstractDiscriminator;
import org.planx.util.Array;

public class ShortArrayDiscriminator
extends AbstractDiscriminator<short[]> {
    private static final int INIT_CAPACITY = 10;
    private Memory memory;

    public ShortArrayDiscriminator(Memory memory) {
        this.memory = memory;
    }

    @Override
    public <U, S> Collection<List<S>> discriminate(List<? extends U> values, Extractor<U, ? extends short[], S> e) {
        int vsize = values.size();
        switch (vsize) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                List<S> l = Collections.singletonList(e.getValue(values.get(0)));
                return Collections.singletonList(l);
            }
            case 2: {
                U u1 = values.get(0);
                U u2 = values.get(1);
                short[] i1 = e.getLabel(u1);
                short[] i2 = e.getLabel(u2);
                if (Arrays.equals(i1, i2)) {
                    ArrayList<S> l1 = new ArrayList<S>(2);
                    l1.add(e.getValue(u1));
                    l1.add(e.getValue(u2));
                    return Collections.singletonList(l1);
                }
                ArrayList<List<S>> r = new ArrayList<List<S>>(2);
                List<S> l1 = Collections.singletonList(e.getValue(u1));
                List<S> l2 = Collections.singletonList(e.getValue(u2));
                r.add(l1);
                r.add(l2);
                return r;
            }
        }
        if (!(values instanceof RandomAccess)) {
            values = new ArrayList<U>(values);
        }
        List[] dictionary = this.memory.dictionary;
        int[] used = this.memory.used;
        int used_size = 0;
        ArrayList<List<S>> result = new ArrayList<List<S>>();
        ArrayList<S> finished = new ArrayList<S>();
        int[] indexes = new int[10];
        List[] work = new List[10];
        int work_capacity = 10;
        int work_head = 1;
        work[0] = values;
        while (work_head > 0) {
            int i;
            List block;
            int blockSize;
            if (work_head < work_capacity) {
                work[work_head] = null;
            }
            int initSubSize = (blockSize = (block = work[--work_head]).size()) < 10 ? blockSize : 10;
            int index = indexes[work_head];
            used_size = 0;
            for (i = 0; i < blockSize; ++i) {
                Object elm = block.get(i);
                short[] seq = e.getLabel(elm);
                if (seq.length <= index) {
                    finished.add(e.getValue(elm));
                    continue;
                }
                int c = seq[index];
                ArrayList list = dictionary[c];
                if (list == null) {
                    dictionary[c] = list = new ArrayList(initSubSize);
                    used[used_size++] = c;
                }
                list.add(elm);
            }
            if (!finished.isEmpty()) {
                result.add(finished);
                finished = new ArrayList();
            }
            ++index;
            for (i = 0; i < used_size; ++i) {
                int idx = used[i];
                List subBlock = dictionary[idx];
                dictionary[idx] = null;
                if (subBlock.size() > 1) {
                    if (work_head + 1 >= work_capacity) {
                        work = Array.ensureCapacity(work, work_head, work_capacity + 1);
                        indexes = Array.ensureCapacity(indexes, work_head, work_capacity + 1);
                        work_capacity = work.length;
                    }
                    work[work_head] = subBlock;
                    indexes[work_head] = index;
                    ++work_head;
                    continue;
                }
                result.add(Discriminators.valueList(subBlock, e));
            }
        }
        return result;
    }
}

