/*
 * Decompiled with CFR 0.152.
 */
package debug;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class Debug {
    public static int traceSize = 200;
    public static boolean doTrace = false;
    public static boolean liveMeasure = false;
    public static boolean liveDebug = false;
    public static boolean isEnabled = false;
    private static Object semaphore = new Object();
    private static LinkedList<String> buf = new LinkedList();
    private static List<DEntry> dbg = new ArrayList<DEntry>();
    private static long last = System.nanoTime();
    private static String dinfo = null;
    private static List<DEntry> m_dbg = new ArrayList<DEntry>();
    private static long m_last = System.nanoTime();
    private static String m_dinfo = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void out(Object string) {
        Object object = semaphore;
        synchronized (object) {
            boolean isFirst;
            String info = string.toString();
            if (doTrace) {
                buf.add(info);
                if (buf.size() > traceSize) {
                    buf.remove();
                }
                return;
            }
            if (!isEnabled) {
                return;
            }
            if (liveDebug) {
                System.out.println(string);
                return;
            }
            boolean bl = isFirst = dinfo == null;
            if (isFirst) {
                dinfo = "INIT";
            }
            long now = System.nanoTime();
            long elapsed = now - last;
            last = now;
            DEntry d = new DEntry(dinfo, elapsed);
            dinfo = info;
            if (!isFirst) {
                System.out.println(String.format("%1$8.3f s", (double)d.elapsed / 1.0E9));
            }
            System.out.print(String.format("%1$80s:", info));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void trace() {
        Object object = semaphore;
        synchronized (object) {
            for (String s : buf) {
                System.out.println(s);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<DEntry> dumpTiming() {
        Object object = semaphore;
        synchronized (object) {
            List<DEntry> d = dbg;
            dbg = new ArrayList<DEntry>();
            return d;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void beginMeasure(String info) {
        Object object = semaphore;
        synchronized (object) {
            m_last = System.nanoTime();
            m_dinfo = info;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void endMeasure() {
        Object object = semaphore;
        synchronized (object) {
            long now = System.nanoTime();
            long elapsed = now - m_last;
            m_last = now;
            DEntry d = new DEntry(m_dinfo, elapsed);
            if (liveMeasure) {
                System.out.println(String.format("MEASURE %1$62s:%2$8.3f s", d.info, (double)d.elapsed / 1.0E9));
            }
            m_dbg.add(d);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<DEntry> data() {
        Object object = semaphore;
        synchronized (object) {
            List<DEntry> d = m_dbg;
            m_dbg = new ArrayList<DEntry>();
            return d;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(List<DEntry> dbg) {
        Object object = semaphore;
        synchronized (object) {
            StringBuilder sb = new StringBuilder();
            sb.append("\n");
            for (DEntry d : dbg) {
                sb.append(d);
                sb.append("\n");
            }
            return sb.toString();
        }
    }

    public static class DEntry {
        String info;
        long elapsed;

        DEntry(String s, long elapsed) {
            this.info = s;
            this.elapsed = elapsed;
        }

        public String toString() {
            return String.format("%1$70s:%2$8.3f s", this.info, (double)this.elapsed / 1.0E9);
        }
    }
}

