package org.planx.xpath.function;

import org.planx.xpath.Context;
import org.planx.xpath.Environment;
import org.planx.xpath.Navigator;
import org.planx.xpath.XPathException;
import org.planx.xpath.object.*;

/**
 * Core string function.
 **/
public class StringFunction implements Function {
    public XObject evaluate(XObject[] args, Context ctxt, Environment env,
                                  Navigator nav) throws FunctionException {
        if (args.length == 0) {
            return evaluate(ctxt.getNode(), nav);
        } else if (args.length == 1) {
            return evaluate(args[0], nav);
        } else {
            throw new FunctionException("Illegal number of arguments");
        }
    }

    public XObject evaluate(Object arg, Navigator navigator)
                                   throws FunctionException {
        try {
            if (arg instanceof XString) {
                return (XString) arg;

            } else if (arg instanceof XNodeSet) {
                // Assumes node set is in document order
                XNodeSet set = (XNodeSet) arg;
                if (set.size() == 0) return new XString("");
                String value = navigator.getStringValue(set.get(0));
                return new XString(value);

            } else if (arg instanceof XSimple) {
                return new XString(((XSimple) arg).stringValue());

            } else {
                // Other: Type dependent - use navigator
                return new XString(navigator.getStringValue(arg));
            }
        } catch (XPathException e) {
            throw new FunctionException(e);
        }
    }
}

