package org.planx.xmlstore.references;

import org.planx.xmlstore.Node;

/**
 * Listens for <code>Reference</code> events such as the relocation of data
 * pointed to by a location dependent reference (<code>Locator</code>), and
 * the mapping of a node to a location independent value reference.
 *
 * @author Thomas Ambus
 */
public interface ReferenceListener {
    /**
     * Indicates that the data pointed to by <code>oldLoc</code> has been
     * relocated to <code>newLoc</code>.
     */
    public void referenceMoved(Locator oldLoc, Locator newLoc);

    /**
     * Request a lookup of the value reference of a node.
     */
    public ContentValueReference lookup(Node node);

    /**
     * Allow the listener to register a new mapping between a node and a
     * value reference.
     */
    public void referenceComputed(Node node, ContentValueReference vref);
}
