package org.planx.msd.lang;

/**
 * An object which can be discriminated using <code>EquivalenceClass</code>
 * pointers. Discrimination can be done using {@link EquivalenceClassDiscriminator}.
 *
 * @author Thomas Ambus
 */
public interface EquivalenceClassDiscriminable {
    /**
     * Returns the <code>EquivalenceClass</code> that this object belongs to.
     */
    public EquivalenceClass getEquivalenceClass();

    /**
     * Changes the <code>EquivalenceClass</code> of this object to the
     * specified <code>EquivalenceClass</code> (optional operation).
     * If this operation is not supported an
     * <code>UnsupportedOperationException</code> will be thrown.
     */
    public void setEquivalenceClass(EquivalenceClass eqCls)
                throws UnsupportedOperationException;
}
