/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xpath.expr.axis;

import org.planx.xpath.Navigator;
import org.planx.xpath.XPathException;
import org.planx.xpath.expr.axis.Axis;
import org.planx.xpath.expr.axis.AxisIterator;

public class SelfAxis
extends Axis {
    @Override
    public AxisIterator iterator(Object contextNode, Navigator navigator) throws XPathException {
        return new SelfAxisIterator(contextNode, navigator);
    }

    @Override
    public int getPrincipalNodeType() {
        return 2;
    }

    @Override
    public boolean isReverse() {
        return false;
    }

    public String toString() {
        return "self";
    }

    class SelfAxisIterator
    implements AxisIterator {
        private Object contextNode;
        private boolean isDone = false;

        SelfAxisIterator(Object contextNode, Navigator navigator) throws XPathException {
            this.contextNode = contextNode;
        }

        @Override
        public boolean hasNext() {
            return !this.isDone && this.contextNode != null;
        }

        @Override
        public Object next() throws XPathException {
            if (this.isDone) {
                throw new XPathException("No more elements in iterator");
            }
            this.isDone = true;
            return this.contextNode;
        }
    }
}

