/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xpath.expr.axis;

import org.planx.xpath.Navigator;
import org.planx.xpath.XPathException;
import org.planx.xpath.expr.axis.Axis;
import org.planx.xpath.expr.axis.AxisIterator;

public class AncestorAxis
extends Axis {
    private final boolean includeSelf;

    public AncestorAxis() {
        this(false);
    }

    public AncestorAxis(boolean includeSelf) {
        this.includeSelf = includeSelf;
    }

    @Override
    public AxisIterator iterator(Object contextNode, Navigator navigator) throws XPathException {
        return new AncestorAxisIterator(contextNode, navigator);
    }

    @Override
    public int getPrincipalNodeType() {
        return 2;
    }

    @Override
    public boolean isReverse() {
        return true;
    }

    public String toString() {
        if (this.includeSelf) {
            return "ancestor-or-self";
        }
        return "ancestor";
    }

    class AncestorAxisIterator
    implements AxisIterator {
        private Object currentNode;
        private Navigator navigator;
        private XPathException currentException = null;

        AncestorAxisIterator(Object contextNode, Navigator navigator) throws XPathException {
            this.currentNode = contextNode;
            this.navigator = navigator;
            if (!AncestorAxis.this.includeSelf) {
                this.next();
            }
        }

        @Override
        public boolean hasNext() {
            return this.currentNode != null;
        }

        @Override
        public Object next() throws XPathException {
            if (this.currentException != null) {
                throw this.currentException;
            }
            if (this.currentNode == null) {
                throw new XPathException("No more elements in iterator");
            }
            Object result = this.currentNode;
            try {
                this.currentNode = this.navigator.getParent(this.currentNode);
            }
            catch (XPathException e) {
                this.currentException = e;
                this.currentNode = null;
            }
            return result;
        }
    }
}

