/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.stores;

import java.io.IOException;
import org.planx.xmlstore.Node;
import org.planx.xmlstore.Reference;
import org.planx.xmlstore.UnknownReferenceException;
import org.planx.xmlstore.io.PersistentMap;
import org.planx.xmlstore.io.PolymorphicStreamer;
import org.planx.xmlstore.io.Streamer;
import org.planx.xmlstore.io.Streamers;
import org.planx.xmlstore.references.AbstractReferenceListener;
import org.planx.xmlstore.references.ContentValueReference;
import org.planx.xmlstore.references.Locator;
import org.planx.xmlstore.stores.AbstractXMLStore;
import org.planx.xmlstore.stores.LocalXMLStore;

public class TranslatorXMLStore
extends AbstractXMLStore {
    private PersistentMap<ContentValueReference, Reference> refserver;
    private LocalXMLStore localXMLStore;

    public TranslatorXMLStore(LocalXMLStore xmlstore) throws IOException {
        super(xmlstore);
        this.localXMLStore = xmlstore;
        String name = xmlstore.toString();
        Streamer<ContentValueReference> s1 = ContentValueReference.getStreamer();
        PolymorphicStreamer<Reference> s2 = Streamers.getPolymorphicStreamer(Reference.class);
        this.refserver = new PersistentMap<ContentValueReference, Reference>(name + ".global.map", s1, s2);
        this.localXMLStore.addReferenceListener(new TranslatorListener());
    }

    @Override
    protected Node resolvedLoad(Reference vref) throws IOException, UnknownReferenceException {
        this.checkClosed();
        if (vref instanceof ContentValueReference) {
            Reference loc = this.refserver.get((ContentValueReference)vref);
            if (loc == null) {
                throw new UnknownReferenceException(vref);
            }
            Node root = this.xmlstore.load(loc);
            return root;
        }
        return this.xmlstore.load(vref);
    }

    @Override
    public Reference save(Node node) throws IOException {
        this.checkClosed();
        Reference vref = this.xmlstore.save(node);
        ContentValueReference gref = new ContentValueReference(node);
        this.refserver.put(gref, vref);
        return gref;
    }

    public void retain(Reference ref) throws UnknownReferenceException {
        Reference loc = this.refserver.get((ContentValueReference)ref);
        this.localXMLStore.retain(loc);
    }

    public void release(Reference ref) throws UnknownReferenceException {
        Reference loc = this.refserver.get((ContentValueReference)ref);
        this.localXMLStore.release(loc);
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.refserver = null;
    }

    private class TranslatorListener
    extends AbstractReferenceListener {
        private TranslatorListener() {
        }

        @Override
        public void referenceMoved(Locator oldLoc, Locator newLoc) {
            try {
                TranslatorXMLStore.this.refserver.replace(oldLoc, newLoc);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

