/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.stores;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.planx.xmlstore.XMLStore;
import org.planx.xmlstore.stores.NetworkRequestHandler;
import org.planx.xmlstore.util.Concurrency;

public class NetworkSkeleton {
    private XMLStore xmlstore;
    private ServerSocket serverSocket;
    private boolean isRunning = true;

    public NetworkSkeleton(XMLStore xmlstore, int port) {
        String host;
        this.xmlstore = xmlstore;
        try {
            host = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            host = "127.0.0.1";
        }
        System.out.println("Starting NetworkSkeleton on " + host + ":" + port);
        try {
            this.serverSocket = new ServerSocket(port);
            new Thread(){

                @Override
                public void run() {
                    NetworkSkeleton.this.listen();
                }
            }.start();
        }
        catch (IOException e) {
            System.out.println("Couldn't bind socket: " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listen() {
        block19: {
            block17: while (true) {
                try {
                    while (this.isRunning) {
                        Socket socket = this.serverSocket.accept();
                        socket.setKeepAlive(true);
                        try {
                            NetworkRequestHandler runnable = new NetworkRequestHandler(this.xmlstore, socket);
                            Concurrency.networkExecutor().execute(runnable);
                            continue block17;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    break block19;
                }
                catch (SocketException e) {
                    break block19;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    break block19;
                }
            }
            finally {
                try {
                    this.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public synchronized void close() throws IOException {
        if (this.isRunning) {
            this.isRunning = false;
            System.out.println("Stopping NetworkSkeleton");
            this.serverSocket.close();
        }
    }
}

