/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.routing.operation;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.planx.xmlstore.routing.Configuration;
import org.planx.xmlstore.routing.Identifier;
import org.planx.xmlstore.routing.Node;
import org.planx.xmlstore.routing.RoutingException;
import org.planx.xmlstore.routing.Space;
import org.planx.xmlstore.routing.messaging.MessageServer;
import org.planx.xmlstore.routing.operation.NodeLookupOperation;
import org.planx.xmlstore.routing.operation.Operation;

public class ResponsibleOperation
extends Operation {
    private Configuration conf;
    private MessageServer server;
    private Space space;
    private Node local;
    private Identifier key;

    public ResponsibleOperation(Configuration conf, MessageServer server, Space space, Node local, Identifier key) {
        if (key == null) {
            throw new NullPointerException("Key is null");
        }
        this.conf = conf;
        this.server = server;
        this.space = space;
        this.local = local;
        this.key = key;
    }

    @Override
    public synchronized Object execute() throws IOException, RoutingException {
        NodeLookupOperation op = new NodeLookupOperation(this.conf, this.server, this.space, this.local, this.key);
        List nodes = (List)((Operation)op).execute();
        ArrayList<InetSocketAddress> info = new ArrayList<InetSocketAddress>(nodes.size());
        int max = nodes.size();
        for (int i = 0; i < max; ++i) {
            Node node = (Node)nodes.get(i);
            info.add(new InetSocketAddress(node.getInetAddress(), node.getContactPort()));
        }
        return info;
    }
}

