/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.routing.operation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.planx.xmlstore.routing.Configuration;
import org.planx.xmlstore.routing.Identifier;
import org.planx.xmlstore.routing.Node;
import org.planx.xmlstore.routing.RoutingException;
import org.planx.xmlstore.routing.Space;
import org.planx.xmlstore.routing.messaging.Message;
import org.planx.xmlstore.routing.messaging.MessageServer;
import org.planx.xmlstore.routing.messaging.Receiver;
import org.planx.xmlstore.routing.messaging.UnknownMessageException;
import org.planx.xmlstore.routing.operation.LookupMessage;
import org.planx.xmlstore.routing.operation.NodeLookupMessage;
import org.planx.xmlstore.routing.operation.NodeReplyMessage;
import org.planx.xmlstore.routing.operation.Operation;

public class NodeLookupOperation
extends Operation
implements Receiver {
    private static final Byte UNASKED = new Byte(0);
    private static final Byte AWAITING = new Byte(1);
    private static final Byte ASKED = new Byte(2);
    private static final Byte FAILED = new Byte(3);
    protected Configuration conf;
    protected MessageServer server;
    protected Space space;
    protected Node local;
    protected Identifier id;
    protected boolean error;
    protected LookupMessage lookupMessage;
    private Comparator cmp;
    private SortedMap nodes;
    private Map transit;

    public NodeLookupOperation(Configuration conf, MessageServer server, Space space, Node local, Identifier id) {
        this.conf = conf;
        this.server = server;
        this.space = space;
        this.local = local;
        this.id = id;
        this.lookupMessage = new NodeLookupMessage(local, id);
        Node.DistanceComparator distCmp = new Node.DistanceComparator(id);
        this.nodes = new TreeMap(distCmp);
        this.transit = new HashMap();
        this.cmp = distCmp;
    }

    @Override
    public synchronized Object execute() throws IOException, RoutingException {
        try {
            this.error = true;
            this.nodes.put(this.local, ASKED);
            this.addNodes(this.space.getAll());
            if (!this.askNodesOrFinish()) {
                this.wait(this.conf.OPERATION_TIMEOUT);
                if (this.error) {
                    throw new RoutingException("Lookup timeout");
                }
            }
            return this.closestNodes(ASKED);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized void receive(Message incoming, int comm) throws IOException {
        NodeReplyMessage mess = (NodeReplyMessage)incoming;
        Node origin = mess.getOrigin();
        this.space.insertNode(origin);
        this.nodes.put(origin, ASKED);
        this.transit.remove(new Integer(comm));
        this.addNodes(mess.getNodes());
        this.askNodesOrFinish();
    }

    @Override
    public synchronized void timeout(int comm) throws IOException {
        Integer c = new Integer(comm);
        Node node = (Node)this.transit.get(c);
        if (node == null) {
            throw new UnknownMessageException("Incoming comm " + comm + " unknown");
        }
        this.nodes.put(node, FAILED);
        this.space.removeNode(node);
        this.transit.remove(c);
        this.askNodesOrFinish();
    }

    private boolean askNodesOrFinish() throws IOException {
        if (this.transit.size() >= this.conf.CONCURRENCY) {
            return false;
        }
        List ask = this.filterClosestNodes(UNASKED);
        if (ask.size() == 0 && this.transit.size() == 0) {
            this.error = false;
            this.notify();
            return true;
        }
        Collections.sort(ask, this.cmp);
        for (int i = 0; this.transit.size() < this.conf.CONCURRENCY && i < ask.size(); ++i) {
            Node node = (Node)ask.get(i);
            int comm = this.server.send(this.lookupMessage, node.getInetAddress(), node.getPort(), this);
            this.nodes.put(node, AWAITING);
            this.transit.put(new Integer(comm), node);
        }
        return false;
    }

    private List closestNodes(Byte status) {
        int remaining = this.conf.K;
        ArrayList matches = new ArrayList(this.conf.K);
        Iterator it = this.nodes.entrySet().iterator();
        while (it.hasNext() && remaining > 0) {
            Map.Entry entry = it.next();
            if (!status.equals(entry.getValue())) continue;
            matches.add(entry.getKey());
            --remaining;
        }
        return matches;
    }

    private List filterClosestNodes(Byte status) {
        int remaining = this.conf.K;
        ArrayList matches = new ArrayList(this.conf.K);
        Iterator it = this.nodes.entrySet().iterator();
        while (it.hasNext() && remaining > 0) {
            Map.Entry entry = it.next();
            Object value = entry.getValue();
            if (FAILED.equals(value)) continue;
            --remaining;
            if (!status.equals(value)) continue;
            matches.add(entry.getKey());
        }
        return matches;
    }

    private void addNodes(List list) {
        int max = list.size();
        for (int i = 0; i < max; ++i) {
            Object o = list.get(i);
            if (this.nodes.containsKey(o)) continue;
            this.nodes.put(o, UNASKED);
        }
    }
}

