/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.routing.operation;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.planx.xmlstore.routing.HashCalculator;
import org.planx.xmlstore.routing.Node;
import org.planx.xmlstore.routing.Space;
import org.planx.xmlstore.routing.messaging.Message;
import org.planx.xmlstore.routing.messaging.MessageServer;
import org.planx.xmlstore.routing.messaging.UnknownMessageException;
import org.planx.xmlstore.routing.operation.HashMessage;
import org.planx.xmlstore.routing.operation.OriginReceiver;
import org.planx.xmlstore.routing.operation.StoreRequestMessage;

public class HashReceiver
extends OriginReceiver {
    private Map localMap;
    private HashCalculator hasher;

    public HashReceiver(MessageServer server, Node local, Space space, Map localMap) {
        super(server, local, space);
        this.localMap = localMap;
        this.hasher = new HashCalculator(local, space, localMap);
    }

    @Override
    public void receive(Message incoming, int comm) throws IOException, UnknownMessageException {
        super.receive(incoming, comm);
        HashMessage mess = (HashMessage)incoming;
        Node origin = mess.getOrigin();
        List inhashes = mess.getHashes();
        List hashes = this.hasher.logarithmicHashes(origin, mess.getBaseTime());
        long interval = 3600000L;
        long previous = Long.MAX_VALUE;
        long current = mess.getBaseTime();
        int max1 = hashes.size();
        int max2 = inhashes.size();
        for (int i = 0; i < max1 && i < max2; ++i) {
            byte[] hash = (byte[])hashes.get(i);
            byte[] inhash = (byte[])inhashes.get(i);
            if (!Arrays.equals(inhash, hash)) {
                StoreRequestMessage req = new StoreRequestMessage(this.local, current, previous);
                this.server.send(req, origin.getInetAddress(), origin.getPort(), null);
            }
            previous = current;
            current -= interval;
            interval *= 2L;
        }
        if (inhashes.size() > hashes.size()) {
            StoreRequestMessage req = new StoreRequestMessage(this.local, Long.MIN_VALUE, previous);
            this.server.send(req, origin.getInetAddress(), origin.getPort(), null);
        }
    }
}

