/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.routing.messaging;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import org.planx.xmlstore.routing.messaging.Message;
import org.planx.xmlstore.routing.messaging.MessageFactory;
import org.planx.xmlstore.routing.messaging.Receiver;

public class MessageServer {
    private static final int DATAGRAM_BUFFER_SIZE = 10240;
    private static Random random = new Random();
    private MessageFactory factory;
    private long timeout;
    private DatagramSocket socket;
    private Timer timer;
    private boolean isRunning = true;
    private Map receivers;
    private Map tasks;

    public MessageServer(int udpPort, MessageFactory factory, long timeout) throws SocketException {
        this.factory = factory;
        this.timeout = timeout;
        this.socket = new DatagramSocket(udpPort);
        this.timer = new Timer(true);
        this.receivers = new HashMap();
        this.tasks = new HashMap();
        new Thread(){

            @Override
            public void run() {
                MessageServer.this.listen();
            }
        }.start();
    }

    public synchronized int send(Message message, InetAddress ip, int port, Receiver recv) throws IOException {
        if (!this.isRunning) {
            throw new IllegalStateException("MessageServer not running");
        }
        int comm = random.nextInt();
        if (recv != null) {
            Integer key = new Integer(comm);
            this.receivers.put(key, recv);
            TimeoutTask task = new TimeoutTask(comm, recv);
            this.timer.schedule((TimerTask)task, this.timeout);
            this.tasks.put(key, task);
        }
        this.sendMessage(comm, message, ip, port);
        return comm;
    }

    public synchronized void reply(int comm, Message message, InetAddress ip, int port) throws IOException {
        if (!this.isRunning) {
            throw new IllegalStateException("MessageServer not running");
        }
        this.sendMessage(comm, message, ip, port);
    }

    private void sendMessage(int comm, Message message, InetAddress ip, int port) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        dout.writeInt(comm);
        dout.writeByte(message.code());
        message.toStream(dout);
        dout.close();
        byte[] data = bout.toByteArray();
        if (data.length > 10240) {
            throw new IOException("Message too big, size=" + data.length + " bytes, max=" + 10240 + " bytes");
        }
        DatagramPacket packet = new DatagramPacket(data, data.length, ip, port);
        this.socket.send(packet);
    }

    private synchronized void unregister(int comm) {
        Integer key = new Integer(comm);
        this.receivers.remove(key);
        this.tasks.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void listen() {
        try {
            while (this.isRunning) {
                try {
                    byte[] buffer = new byte[10240];
                    DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
                    this.socket.receive(packet);
                    ByteArrayInputStream bin = new ByteArrayInputStream(packet.getData(), packet.getOffset(), packet.getLength());
                    DataInputStream din = new DataInputStream(bin);
                    int comm = din.readInt();
                    byte messCode = din.readByte();
                    Message message = this.factory.createMessage(messCode, din);
                    din.close();
                    Receiver recv = null;
                    recv = this.factory.createReceiver(messCode, this);
                    if (recv == null) {
                        MessageServer messageServer = this;
                        synchronized (messageServer) {
                            Integer key = new Integer(comm);
                            recv = (Receiver)this.receivers.remove(key);
                            if (recv != null) {
                                TimerTask task = (TimerTask)this.tasks.remove(key);
                                task.cancel();
                            }
                        }
                    }
                    if (recv == null) continue;
                    recv.receive(message, comm);
                }
                catch (SocketException e) {
                    this.isRunning = false;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return;
        }
        finally {
            if (!this.socket.isClosed()) {
                this.socket.close();
            }
            this.isRunning = false;
        }
    }

    public synchronized void close() {
        if (!this.isRunning) {
            throw new IllegalStateException("MessageServer not running");
        }
        this.isRunning = false;
        this.timer.cancel();
        this.socket.close();
        this.receivers.clear();
        this.tasks.clear();
    }

    class TimeoutTask
    extends TimerTask {
        private int comm;
        private Receiver recv;

        public TimeoutTask(int comm, Receiver recv) {
            this.comm = comm;
            this.recv = recv;
        }

        @Override
        public void run() {
            try {
                MessageServer.this.unregister(this.comm);
                this.recv.timeout(this.comm);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

