/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.regions;

import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import org.planx.xmlstore.UnknownReferenceException;
import org.planx.xmlstore.regions.Region;
import org.planx.xmlstore.regions.RegionManager;

public abstract class Sharer {
    protected RegionManager manager;
    protected Timer timer = null;
    protected TimerTask bgTask = null;
    protected boolean isDiscriminated = true;
    protected boolean isIterated = true;
    protected int invocations = 0;

    Sharer(RegionManager manager) {
        this.manager = manager;
    }

    public synchronized void start() {
        this.timer = new Timer(true);
        this.bgTask = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    RegionManager regionManager = Sharer.this.manager;
                    synchronized (regionManager) {
                        Sharer.this.share();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        long period = this.manager.configuration().SHARER_PERIOD;
        this.timer.schedule(this.bgTask, period, period);
    }

    public synchronized void stop() {
        if (this.bgTask != null) {
            this.bgTask.cancel();
        }
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    public synchronized boolean isDiscriminated() {
        return this.isDiscriminated;
    }

    public synchronized boolean isIterated() {
        return this.isIterated;
    }

    public synchronized int invocations() {
        return this.invocations;
    }

    abstract void addRegion(Region var1) throws IOException, UnknownReferenceException;

    abstract void removeRegion(Region var1);

    public abstract void share() throws IOException, UnknownReferenceException;
}

