/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.nodes;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.planx.util.UnmodifiableArrayList;
import org.planx.xmlstore.Attribute;
import org.planx.xmlstore.Reference;
import org.planx.xmlstore.UnknownReferenceException;
import org.planx.xmlstore.XMLStore;
import org.planx.xmlstore.io.FileSystem;
import org.planx.xmlstore.io.LocalLocator;
import org.planx.xmlstore.io.Streamer;
import org.planx.xmlstore.io.Streamers;
import org.planx.xmlstore.io.UnknownLocatorException;
import org.planx.xmlstore.nodes.DVMAttribute;
import org.planx.xmlstore.nodes.DVMNode;
import org.planx.xmlstore.nodes.LocatorListener;
import org.planx.xmlstore.nodes.SystemNode;
import org.planx.xmlstore.nodes.XMLStoreNodeProxy;
import org.planx.xmlstore.references.RelativeReference;

public class NodeConverter {
    private static final int ELEMENT = 0;
    private static final int CHARDATA = 1;
    private static final int TYPE_MASK = 15;
    private static final int FLAG_IS_SHARED = 128;
    private Streamer<Attribute> attrStreamer;
    private Streamer<Reference> vrefStreamer;
    private Streamer<LocalLocator> locStreamer;
    private XMLStore xmlstore;

    public NodeConverter() {
        this(null);
    }

    public NodeConverter(XMLStore xmlstore) {
        this.xmlstore = xmlstore;
        this.attrStreamer = DVMAttribute.getStreamer();
        this.vrefStreamer = Streamers.getPolymorphicStreamer(Reference.class);
        this.locStreamer = LocalLocator.getStreamer(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalLocator save(SystemNode node, LocalLocator bound, FileSystem fs, LocatorListener listener) throws IOException {
        try {
            FileSystem fileSystem = fs;
            synchronized (fileSystem) {
                return this.saveTree(node, bound, fs, listener);
            }
        }
        catch (UnknownReferenceException e) {
            throw new IOException(e.toString());
        }
    }

    private LocalLocator saveTree(SystemNode node, LocalLocator bound, FileSystem fs, LocatorListener listener) throws IOException, UnknownReferenceException {
        LocalLocator loc = node.getLocator();
        if (!(loc == null || bound != null && bound.isContained(loc))) {
            return loc;
        }
        boolean hasOutgoing = false;
        ArrayList<LocalLocator> childLocs = null;
        if (node.getType() == 0) {
            List<SystemNode> children = node.getChildren();
            childLocs = new ArrayList<LocalLocator>(children.size());
            for (SystemNode n : children) {
                LocalLocator childLoc = this.saveTree(n, bound, fs, listener);
                childLocs.add(childLoc);
                if (fs.isContained(childLoc)) continue;
                hasOutgoing = true;
            }
        }
        loc = fs.allocate();
        int diskType = node.getType() == 0 ? 0 : 1;
        DataOutput out = fs.getOutput(loc);
        out.writeByte(node.isShared() ? diskType | 0x80 : diskType);
        Streamers.writeUTF(out, node.getNodeValue());
        if (diskType == 0) {
            Streamers.writeList(out, node.getAttributes(), this.attrStreamer);
            Streamers.writeShortInt(out, childLocs.size());
            for (LocalLocator l : childLocs) {
                this.locStreamer.toStream(out, l);
            }
        }
        node.setLocator(loc);
        assert (loc.equals(node.getLocator())) : "node did not accept setLocator";
        if (listener != null) {
            listener.nodeSaved(loc, node, hasOutgoing);
        }
        return loc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SystemNode load(LocalLocator loc, Reference secondaryRef, LocalLocator bound, FileSystem fs, LocatorListener listener) throws IOException, UnknownLocatorException {
        FileSystem fileSystem = fs;
        synchronized (fileSystem) {
            return this.loadTree(loc, secondaryRef, bound, fs, listener);
        }
    }

    private SystemNode loadTree(LocalLocator loc, Reference secondaryRef, LocalLocator bound, FileSystem fs, LocatorListener listener) throws IOException, UnknownLocatorException {
        DataInput in = fs.getInput(loc);
        int diskType = in.readByte();
        boolean isShared = (diskType & 0x80) != 0;
        byte nodeType = (diskType &= 0xF) == 0 ? (byte)0 : 1;
        String value = Streamers.readUTF(in);
        List<Attribute> attributes = null;
        UnmodifiableArrayList<SystemNode> children = null;
        boolean hasOutgoing = false;
        if (nodeType == 0) {
            attributes = Streamers.readList(in, this.attrStreamer);
            int size = Streamers.readShortInt(in);
            LocalLocator[] ls = new LocalLocator[size];
            for (int i = 0; i < size; ++i) {
                LocalLocator eloc = this.locStreamer.fromStream(in);
                if (listener != null) {
                    eloc = listener.locatorLoaded(eloc, loc, i);
                }
                ls[i] = eloc;
            }
            SystemNode[] cs = new SystemNode[size];
            for (int i = 0; i < size; ++i) {
                SystemNode n = null;
                LocalLocator l = ls[i];
                if (bound != null && bound.isContained(l)) {
                    if (listener != null) {
                        n = listener.lookup(l);
                    }
                    if (n == null) {
                        if (l.equals(loc)) {
                            throw new IllegalStateException("Node " + loc + " is pointing to itself " + l);
                        }
                        n = this.loadTree(l, secondaryRef, bound, fs, listener);
                    }
                } else {
                    hasOutgoing = true;
                    RelativeReference relRef = secondaryRef == null ? null : new RelativeReference(secondaryRef, i);
                    n = new XMLStoreNodeProxy(l, relRef, this.xmlstore);
                }
                cs[i] = n;
            }
            children = new UnmodifiableArrayList<SystemNode>(cs);
        }
        DVMNode node = new DVMNode(nodeType, value, children, attributes, loc, isShared);
        if (listener != null) {
            listener.nodeLoaded(loc, node, hasOutgoing);
        }
        return node;
    }
}

