/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.nodes;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.planx.msd.Discriminator;
import org.planx.msd.DiscriminatorFactory;
import org.planx.msd.Memory;
import org.planx.msd.character.CharSequenceDiscriminator;
import org.planx.xmlstore.Attribute;
import org.planx.xmlstore.io.Streamer;
import org.planx.xmlstore.io.Streamers;

public class DVMAttribute
implements Attribute,
Comparable<Attribute>,
CharSequence {
    private static final char MAGIC_CHAR = '\u0000';
    private final String name;
    private final String value;

    public DVMAttribute(String name, String value) {
        if (name == null) {
            throw new NullPointerException("Name may not be null");
        }
        if (value == null) {
            throw new NullPointerException("Value may not be null");
        }
        this.name = name;
        this.value = value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public int compareTo(Attribute o) {
        if (o == null) {
            throw new NullPointerException();
        }
        int v = DVMAttribute.compare(this.name, o.getName());
        return v != 0 ? v : DVMAttribute.compare(this.value, o.getValue());
    }

    private static int compare(String s1, String s2) {
        return s1 == s2 ? 0 : (s1 == null ? -1 : (s2 == null ? 1 : s1.compareTo(s2)));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Attribute)) {
            return false;
        }
        Attribute other = (Attribute)o;
        String oName = other.getName();
        String oValue = other.getValue();
        return (this.name == null && oName == null || this.name != null && this.name.equals(oName)) && (this.value == null && oValue == null || this.value != null && this.value.equals(oValue));
    }

    public int hashCode() {
        int h1 = this.name == null ? 0 : this.name.hashCode();
        int h2 = this.value == null ? 0 : this.value.hashCode();
        return 31 * h1 + h2;
    }

    @Override
    public String toString() {
        return this.name + "=" + this.value;
    }

    @Override
    public char charAt(int index) {
        int len1 = this.name.length();
        if (index < len1) {
            return this.name.charAt(index);
        }
        if (index == len1) {
            return '\u0000';
        }
        return this.value.charAt(index - len1 - 1);
    }

    @Override
    public int length() {
        return this.name.length() + this.value.length() + 1;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        throw new UnsupportedOperationException();
    }

    public static Streamer<Attribute> getStreamer() {
        return new Streamer<Attribute>(){

            @Override
            public void toStream(DataOutput out, Attribute attr) throws IOException {
                Streamers.writeUTF(out, attr.getName());
                Streamers.writeUTF(out, attr.getValue());
            }

            @Override
            public Attribute fromStream(DataInput in) throws IOException {
                String name = Streamers.readUTF(in);
                String value = Streamers.readUTF(in);
                return new DVMAttribute(name, value);
            }
        };
    }

    public static Discriminator<Attribute> getDiscriminator() {
        return DVMAttribute.getDiscriminator(DiscriminatorFactory.instance().getMemory());
    }

    public static Discriminator<Attribute> getDiscriminator(Memory memory) {
        return new CharSequenceDiscriminator<Attribute>(memory);
    }
}

