/*
 * Decompiled with CFR 0.152.
 */
package org.planx.msd.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.planx.msd.Discriminator;
import org.planx.msd.Extractor;
import org.planx.msd.util.AbstractDiscriminator;
import org.planx.util.Pair;

public class PairDiscriminator<A, B>
extends AbstractDiscriminator<Pair<A, B>> {
    private final Discriminator<A> d1;
    private final Discriminator<B> d2;

    public PairDiscriminator(Discriminator<A> d1, Discriminator<B> d2) {
        this.d1 = d1;
        this.d2 = d2;
    }

    @Override
    public <U, S> Collection<List<S>> discriminate(List<? extends U> values, final Extractor<U, ? extends Pair<A, B>, S> e) {
        if (values.isEmpty()) {
            return Collections.emptyList();
        }
        Extractor firstExtractor = new Extractor<U, A, U>(){

            @Override
            public A getLabel(U elm) {
                return ((Pair)e.getLabel(elm)).getFirst();
            }

            @Override
            public U getValue(U elm) {
                return elm;
            }
        };
        Collection result1 = this.d1.discriminate(values, firstExtractor);
        Extractor secondExtractor = new Extractor<U, B, S>(){

            @Override
            public B getLabel(U elm) {
                return ((Pair)e.getLabel(elm)).getSecond();
            }

            @Override
            public S getValue(U elm) {
                return e.getValue(elm);
            }
        };
        ArrayList<List<S>> result2 = new ArrayList<List<S>>();
        for (List block : result1) {
            result2.addAll(this.d2.discriminate(block, secondExtractor));
        }
        return result2;
    }
}

