/*
 * Decompiled with CFR 0.152.
 */
package org.planx.msd.number;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.planx.msd.Discriminators;
import org.planx.msd.Extractor;
import org.planx.msd.Memory;
import org.planx.msd.number.IntExtractor;
import org.planx.msd.util.AbstractDiscriminator;

public abstract class NumberDiscriminator<T>
extends AbstractDiscriminator<T> {
    protected static final int CHUNK_BITSIZE = 16;
    protected static final int CHUNK_MASK = 65535;
    protected Memory memory;

    protected NumberDiscriminator(Memory memory) {
        this.memory = memory;
    }

    @Override
    public <U, S> Collection<List<S>> discriminate(List<? extends U> values, Extractor<U, ? extends T, S> e) {
        ChunkExtractor<U> chunkExtractor = this.chunkExtractor(e);
        ArrayList<List<S>> result = new ArrayList<List<S>>();
        List<List<U>> unfin = Collections.singletonList(values);
        int n = this.bitsize();
        for (int offset = 0; offset < n && !unfin.isEmpty(); offset += 16) {
            List<List<U>> work = unfin;
            unfin = new ArrayList<List<? extends U>>();
            for (List list : work) {
                chunkExtractor.setOffset(offset);
                Collection partition = this.memory.discriminate(list, chunkExtractor);
                for (List subBlock : partition) {
                    if (subBlock.size() > 1) {
                        unfin.add(subBlock);
                        continue;
                    }
                    result.add(Discriminators.valueList(subBlock, e));
                }
            }
        }
        for (List list : unfin) {
            result.add(Discriminators.valueList(list, e));
        }
        return result;
    }

    protected abstract int bitsize();

    protected abstract <U> ChunkExtractor<U> chunkExtractor(Extractor<U, ? extends T, ?> var1);

    protected abstract class ChunkExtractor<U>
    implements IntExtractor<U, U> {
        protected int offset = -1;
        protected Extractor<U, ? extends T, ?> e;

        protected ChunkExtractor(Extractor<U, ? extends T, ?> e) {
            this.e = e;
        }

        public void setOffset(int offset) {
            this.offset = offset;
        }

        @Override
        public abstract int getLabel(U var1);

        @Override
        public U getValue(U elm) {
            return elm;
        }
    }
}

