/*
 * Decompiled with CFR 0.152.
 */
package org.planx.msd.graph;

import java.util.Collections;
import java.util.List;
import org.planx.msd.Discriminator;
import org.planx.msd.DiscriminatorFactory;
import org.planx.msd.graph.Compactor;
import org.planx.msd.graph.Navigator;
import org.planx.msd.lang.EquivalenceClass;
import org.planx.msd.lang.EquivalenceClassDiscriminable;
import org.planx.msd.lang.EquivalenceClassDiscriminator;
import org.planx.msd.util.MatchAllDiscriminator;
import org.planx.msd.util.PairDiscriminator;
import org.planx.util.Association;
import org.planx.util.Pair;

public class TemplateNode<N, L>
extends Association<N, List<Pointer>>
implements EquivalenceClassDiscriminable {
    protected Discriminator<N> nameDisc = new MatchAllDiscriminator<N>();
    protected Discriminator<L> labelDisc = new MatchAllDiscriminator<L>();
    protected EquivalenceClass eqCls = new EquivalenceClass();
    protected Object visitToken = null;
    protected int height = -1;

    public TemplateNode(N name) {
        this(name, null);
    }

    public TemplateNode(N name, List<Pointer> pointers) {
        super(name, pointers);
        if (pointers == null) {
            this.second = Collections.emptyList();
        }
    }

    public TemplateNode(N name, List<Pointer> pointers, Discriminator<N> nameDisc, Discriminator<L> labelDisc) {
        this(name, pointers);
        this.nameDisc = nameDisc;
        this.labelDisc = labelDisc;
    }

    public Pointer createPointer(L label, TemplateNode<N, L> node) {
        return new Pointer(label, node);
    }

    public void compact() {
        Navigator<TemplateNode<N, L>> nav = this.getNavigator();
        Discriminator<TemplateNode<N, L>> d = this.getDiscriminator();
        Compactor<TemplateNode<TemplateNode, L>> compactor = new Compactor<TemplateNode<TemplateNode, L>>(nav, d);
        compactor.share(this);
    }

    public N getName() {
        return (N)this.getFirst();
    }

    public void setName(N name) {
        this.first = name;
    }

    public List<Pointer> getPointers() {
        return (List)this.getSecond();
    }

    public void setPointers(List<Pointer> pointers) {
        this.second = pointers;
    }

    @Override
    public EquivalenceClass getEquivalenceClass() {
        return this.eqCls;
    }

    @Override
    public void setEquivalenceClass(EquivalenceClass eqCls) {
        this.eqCls = eqCls;
    }

    public Discriminator<TemplateNode<N, L>> getDiscriminator() {
        DiscriminatorFactory factory = DiscriminatorFactory.instance();
        EquivalenceClassDiscriminator childDisc = new EquivalenceClassDiscriminator();
        PairDiscriminator ptrDisc = new PairDiscriminator(this.labelDisc, childDisc);
        Discriminator ptrSetDisc = factory.getSetDiscriminator(ptrDisc);
        PairDiscriminator nodeDisc = new PairDiscriminator(this.nameDisc, ptrSetDisc);
        return nodeDisc;
    }

    public Navigator<TemplateNode<N, L>> getNavigator() {
        return new TemplateNavigator();
    }

    protected class TemplateNavigator
    implements Navigator<TemplateNode<N, L>> {
        protected TemplateNavigator() {
        }

        @Override
        public TemplateNode<N, L> getChild(TemplateNode<N, L> node, int index) {
            return node.getPointers().get(index).getNode();
        }

        @Override
        public void setChild(TemplateNode<N, L> node, int index, TemplateNode<N, L> child) {
            node.getPointers().get(index).setNode(child);
        }

        @Override
        public int childCount(TemplateNode<N, L> node) {
            return node.getPointers().size();
        }

        @Override
        public Object getVisitToken(TemplateNode<N, L> node) {
            return node.visitToken;
        }

        @Override
        public void setVisitToken(TemplateNode<N, L> node, Object token) {
            node.visitToken = token;
        }

        @Override
        public int getHeight(TemplateNode<N, L> node) {
            return node.height;
        }

        @Override
        public void setHeight(TemplateNode<N, L> node, int height) {
            node.height = height;
        }

        @Override
        public boolean isOutside(TemplateNode<N, L> node) {
            return false;
        }

        @Override
        public TemplateNode<N, L> chooseCanonical(List<Compactor.Edge> eqCls) {
            return (TemplateNode)eqCls.get((int)0).node;
        }
    }

    public class Pointer
    extends Association<L, TemplateNode<N, L>>
    implements Pair<L, TemplateNode<N, L>> {
        public Pointer(L label, TemplateNode<N, L> node) {
            super(label, node);
        }

        public L getLabel() {
            return this.getFirst();
        }

        public void setLabel(L label) {
            this.first = label;
        }

        public TemplateNode<N, L> getNode() {
            return (TemplateNode)this.getSecond();
        }

        public void setNode(TemplateNode<N, L> node) {
            this.second = node;
        }
    }
}

