/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.common;

import java.util.Collection;
import org.parboiled.common.ImmutableList;
import org.parboiled.common.Preconditions;
import org.parboiled.common.Predicate;
import org.parboiled.common.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Predicates {
    private Predicates() {
    }

    public static <T> Predicate<T> alwaysTrue() {
        return AlwaysTruePredicate.INSTANCE;
    }

    public static <T> Predicate<T> alwaysFalse() {
        return AlwaysFalsePredicate.INSTANCE;
    }

    public static <T> Predicate<T> isNull() {
        return IsNullPredicate.INSTANCE;
    }

    public static <T> Predicate<T> notNull() {
        return NotNullPredicate.INSTANCE;
    }

    public static <T> Predicate<T> not(Predicate<T> predicate) {
        return new NotPredicate(predicate);
    }

    public static <T> Predicate<T> and(Collection<? extends Predicate<? super T>> components) {
        return new AndPredicate(components);
    }

    public static <T> Predicate<T> and(Predicate<? super T> ... components) {
        return new AndPredicate(ImmutableList.of(components));
    }

    public static <T> Predicate<T> and(Predicate<? super T> first, Predicate<? super T> second) {
        Preconditions.checkArgNotNull(first, "first");
        Preconditions.checkArgNotNull(second, "second");
        return new AndPredicate(ImmutableList.of(first, second));
    }

    public static <T> Predicate<T> or(Collection<? extends Predicate<? super T>> components) {
        return new OrPredicate(components);
    }

    public static <T> Predicate<T> or(Predicate<? super T> ... components) {
        return new OrPredicate(ImmutableList.of(components));
    }

    public static <T> Predicate<T> or(Predicate<? super T> first, Predicate<? super T> second) {
        Preconditions.checkArgNotNull(first, "first");
        Preconditions.checkArgNotNull(second, "second");
        return new OrPredicate(ImmutableList.of(first, second));
    }

    public static <T> Predicate<T> equalTo(T target) {
        return target == null ? Predicates.isNull() : new IsEqualToPredicate(target);
    }

    public static Predicate<Object> instanceOf(Class<?> clazz) {
        return new InstanceOfPredicate(clazz);
    }

    public static <T> Predicate<T> in(Collection<? extends T> target) {
        return new InPredicate(target);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InPredicate<T>
    implements Predicate<T> {
        private final Collection<?> target;

        private InPredicate(Collection<?> target) {
            Preconditions.checkArgNotNull(target, "target");
            this.target = target;
        }

        @Override
        public boolean apply(T t) {
            try {
                return this.target.contains(t);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public String toString() {
            return "In(" + this.target + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NotNullPredicate
    implements Predicate<Object> {
        private static final Predicate<Object> INSTANCE = new NotNullPredicate();

        private NotNullPredicate() {
        }

        @Override
        public boolean apply(Object o) {
            return o != null;
        }

        public String toString() {
            return "NotNull";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IsNullPredicate
    implements Predicate<Object> {
        private static final Predicate<Object> INSTANCE = new IsNullPredicate();

        private IsNullPredicate() {
        }

        @Override
        public boolean apply(Object o) {
            return o == null;
        }

        public String toString() {
            return "IsNull";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InstanceOfPredicate
    implements Predicate<Object> {
        private final Class<?> clazz;

        private InstanceOfPredicate(Class<?> clazz) {
            Preconditions.checkArgNotNull(clazz, "clazz");
            this.clazz = clazz;
        }

        @Override
        public boolean apply(Object o) {
            return this.clazz.isInstance(o);
        }

        public String toString() {
            return "IsInstanceOf(" + this.clazz.getName() + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IsEqualToPredicate<T>
    implements Predicate<T> {
        private final T target;

        private IsEqualToPredicate(T target) {
            this.target = target;
        }

        @Override
        public boolean apply(T t) {
            return this.target.equals(t);
        }

        public String toString() {
            return "IsEqualTo(" + this.target + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OrPredicate<T>
    implements Predicate<T> {
        private final Collection<? extends Predicate<? super T>> components;

        private OrPredicate(Collection<? extends Predicate<? super T>> components) {
            this.components = components;
        }

        @Override
        public boolean apply(T t) {
            for (Predicate<T> predicate : this.components) {
                if (!predicate.apply(t)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return "Or(" + StringUtils.join(this.components, ", ") + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AndPredicate<T>
    implements Predicate<T> {
        private final Collection<? extends Predicate<? super T>> components;

        private AndPredicate(Collection<? extends Predicate<? super T>> components) {
            this.components = components;
        }

        @Override
        public boolean apply(T t) {
            for (Predicate<T> predicate : this.components) {
                if (predicate.apply(t)) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return "And(" + StringUtils.join(this.components, ", ") + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NotPredicate<T>
    implements Predicate<T> {
        private final Predicate<T> predicate;

        private NotPredicate(Predicate<T> predicate) {
            Preconditions.checkArgNotNull(predicate, "predicate");
            this.predicate = predicate;
        }

        @Override
        public boolean apply(T t) {
            return !this.predicate.apply(t);
        }

        public String toString() {
            return "Not(" + this.predicate.toString() + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AlwaysFalsePredicate
    implements Predicate<Object> {
        private static final Predicate<Object> INSTANCE = new AlwaysFalsePredicate();

        private AlwaysFalsePredicate() {
        }

        @Override
        public boolean apply(Object o) {
            return false;
        }

        public String toString() {
            return "AlwaysFalse";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AlwaysTruePredicate
    implements Predicate<Object> {
        private static final Predicate<Object> INSTANCE = new AlwaysTruePredicate();

        private AlwaysTruePredicate() {
        }

        @Override
        public boolean apply(Object o) {
            return true;
        }

        public String toString() {
            return "AlwaysTrue";
        }
    }
}

