/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.update.nvd;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang3.StringUtils;
import org.owasp.dependencycheck.data.nvdcve.CveDB;
import org.owasp.dependencycheck.data.update.exception.UpdateException;
import org.owasp.dependencycheck.data.update.nvd.NvdCache;
import org.owasp.dependencycheck.data.update.nvd.NvdCveInfo;
import org.owasp.dependencycheck.data.update.nvd.ProcessTask;
import org.owasp.dependencycheck.utils.DownloadFailedException;
import org.owasp.dependencycheck.utils.Downloader;
import org.owasp.dependencycheck.utils.ResourceNotFoundException;
import org.owasp.dependencycheck.utils.Settings;
import org.owasp.dependencycheck.utils.TooManyRequestsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class DownloadTask
implements Callable<Future<ProcessTask>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DownloadTask.class);
    private final CveDB cveDB;
    private final ExecutorService processorService;
    private NvdCveInfo nvdCveInfo;
    private final Settings settings;
    private File file;

    public DownloadTask(NvdCveInfo nvdCveInfo, ExecutorService processor, CveDB cveDB, Settings settings) throws UpdateException {
        this.nvdCveInfo = nvdCveInfo;
        this.processorService = processor;
        this.cveDB = cveDB;
        this.settings = settings;
        try {
            this.file = File.createTempFile("cve" + nvdCveInfo.getId() + '_', ".json.gz", settings.getTempDirectory());
        }
        catch (IOException ex) {
            throw new UpdateException("Unable to create temporary files", ex);
        }
    }

    public NvdCveInfo getNvdCveInfo() {
        return this.nvdCveInfo;
    }

    public void setNvdCveInfo(NvdCveInfo nvdCveInfo) {
        this.nvdCveInfo = nvdCveInfo;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public Future<ProcessTask> call() throws Exception {
        long waitTime = this.settings.getInt("cve.download.waittime", 4000);
        long startDownload = 0L;
        NvdCache cache = new NvdCache(this.settings);
        try {
            Future<ProcessTask> val;
            URL url1 = new URL(this.nvdCveInfo.getUrl());
            if (cache.notInCache(url1, this.file)) {
                Thread.sleep(waitTime);
                LOGGER.info("Download Started for NVD CVE - {}", (Object)this.nvdCveInfo.getId());
                startDownload = System.currentTimeMillis();
                int downloadAttempts = 5;
                for (int x = 2; x <= 5 && !this.attemptDownload(url1, x == 5); ++x) {
                    LOGGER.info("Download Attempt {} for NVD CVE - {}", (Object)x, (Object)this.nvdCveInfo.getId());
                    Thread.sleep(waitTime * (long)(x / 2));
                }
                if (this.file.isFile() && this.file.length() > 0L) {
                    LOGGER.info("Download Complete for NVD CVE - {}  ({} ms)", (Object)this.nvdCveInfo.getId(), (Object)(System.currentTimeMillis() - startDownload));
                    cache.storeInCache(url1, this.file);
                } else {
                    throw new DownloadFailedException("Unable to download NVD CVE " + this.nvdCveInfo.getId());
                }
            }
            if (this.processorService == null) {
                Future<ProcessTask> downloadAttempts = null;
                return downloadAttempts;
            }
            ProcessTask task = new ProcessTask(this.cveDB, this, this.settings);
            Future<ProcessTask> future = val = this.processorService.submit(task);
            return future;
        }
        catch (Throwable ex) {
            LOGGER.error("Error downloading NVD CVE - {} Reason: {}", (Object)this.nvdCveInfo.getId(), (Object)ex.getMessage());
            throw ex;
        }
        finally {
            this.settings.cleanup(false);
        }
    }

    private boolean attemptDownload(URL url1, boolean showLog) throws TooManyRequestsException, ResourceNotFoundException {
        try {
            Downloader downloader = new Downloader(this.settings);
            downloader.fetchFile(url1, this.file, "cve.user", "cve.password");
        }
        catch (DownloadFailedException ex) {
            if (showLog) {
                LOGGER.error("Download Failed for NVD CVE - {}\nSome CVEs may not be reported. Reason: {}", (Object)this.nvdCveInfo.getId(), (Object)ex.getMessage());
                if (this.settings.getString("proxy.server") == null) {
                    LOGGER.error("If you are behind a proxy you may need to configure dependency-check to use the proxy.");
                }
                LOGGER.debug("", (Throwable)ex);
            }
            return false;
        }
        return true;
    }

    public void cleanup() {
        if (this.file != null && this.file.exists() && !this.file.delete()) {
            LOGGER.debug("Failed to delete first temporary file {}", (Object)this.file.toString());
            this.file.deleteOnExit();
        }
    }

    public void evictCorruptFileFromCache() {
        NvdCache cache = new NvdCache(this.settings);
        try {
            URL url1 = new URL(this.nvdCveInfo.getUrl());
            cache.evictFromCache(url1);
        }
        catch (MalformedURLException e) {
            LOGGER.debug("Ignoring Cache-eviction request for an invalid URL");
        }
    }

    public boolean isModified() {
        return StringUtils.containsIgnoreCase((CharSequence)this.file.toString(), (CharSequence)"modified");
    }
}

