/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import javax.json.Json;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.apache.commons.io.FileUtils;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.Retired;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.EvidenceType;
import org.owasp.dependencycheck.exception.InitializationException;
import org.owasp.dependencycheck.utils.FileFilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Retired
@ThreadSafe
public class NodePackageAnalyzer
extends AbstractFileTypeAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodePackageAnalyzer.class);
    public static final String DEPENDENCY_ECOSYSTEM = "npm";
    private static final String ANALYZER_NAME = "Node.js Package Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.INFORMATION_COLLECTION;
    public static final String PACKAGE_JSON = "package.json";
    private static final FileFilter PACKAGE_JSON_FILTER = FileFilterBuilder.newInstance().addFilenames("package.json").build();

    @Override
    protected FileFilter getFileFilter() {
        return PACKAGE_JSON_FILTER;
    }

    @Override
    protected void prepareFileTypeAnalyzer(Engine engine) throws InitializationException {
    }

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.node.package.enabled";
    }

    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        dependency.setEcosystem(DEPENDENCY_ECOSYSTEM);
        File file = dependency.getActualFile();
        if (!file.isFile() || file.length() == 0L) {
            return;
        }
        try (JsonReader jsonReader = Json.createReader((InputStream)FileUtils.openInputStream((File)file));){
            JsonObject json = jsonReader.readObject();
            if (json.containsKey((Object)"name")) {
                Object value = json.get((Object)"name");
                if (value instanceof JsonString) {
                    String valueString = ((JsonString)value).getString();
                    dependency.setName(valueString);
                    dependency.addEvidence(EvidenceType.PRODUCT, PACKAGE_JSON, "name", valueString, Confidence.HIGHEST);
                    dependency.addEvidence(EvidenceType.VENDOR, PACKAGE_JSON, "name_project", String.format("%s_project", valueString), Confidence.LOW);
                } else {
                    LOGGER.warn("JSON value not string as expected: {}", value);
                }
            }
            this.addToEvidence(dependency, EvidenceType.PRODUCT, json, "description");
            this.addToEvidence(dependency, EvidenceType.VENDOR, json, "author");
            String version = this.addToEvidence(dependency, EvidenceType.VERSION, json, "version");
            dependency.setVersion(version);
        }
        catch (JsonException e) {
            LOGGER.warn("Failed to parse package.json file.", (Throwable)e);
        }
        catch (IOException e) {
            throw new AnalysisException("Problem occurred while reading dependency file.", e);
        }
    }

    private String addToEvidence(Dependency dep, EvidenceType t, JsonObject json, String key) {
        String evidenceStr = null;
        if (json.containsKey((Object)key)) {
            JsonValue value = (JsonValue)json.get((Object)key);
            if (value instanceof JsonString) {
                evidenceStr = ((JsonString)value).getString();
                dep.addEvidence(t, PACKAGE_JSON, key, evidenceStr, Confidence.HIGHEST);
            } else if (value instanceof JsonObject) {
                JsonObject jsonObject = (JsonObject)value;
                for (Map.Entry entry : jsonObject.entrySet()) {
                    String property = (String)entry.getKey();
                    JsonValue subValue = (JsonValue)entry.getValue();
                    if (subValue instanceof JsonString) {
                        evidenceStr = ((JsonString)subValue).getString();
                        dep.addEvidence(t, PACKAGE_JSON, String.format("%s.%s", key, property), evidenceStr, Confidence.HIGHEST);
                        continue;
                    }
                    LOGGER.warn("JSON sub-value not string as expected: {}", (Object)subValue);
                }
            } else {
                LOGGER.warn("JSON value not string or JSON object as expected: {}", (Object)value);
            }
        }
        return evidenceStr;
    }
}

