/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.lucene;

import java.io.IOException;
import java.util.LinkedList;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

public final class TokenPairConcatenatingFilter
extends TokenFilter {
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private String previousWord;
    private final LinkedList<String> words = new LinkedList();

    public TokenPairConcatenatingFilter(TokenStream stream) {
        super(stream);
    }

    public boolean incrementToken() throws IOException {
        String word;
        while (this.input.incrementToken()) {
            word = new String(this.termAtt.buffer(), 0, this.termAtt.length());
            this.words.add(word);
        }
        if (this.previousWord != null && !this.words.isEmpty()) {
            word = this.words.getFirst();
            this.clearAttributes();
            this.termAtt.append(this.previousWord).append(word);
            this.previousWord = null;
            return true;
        }
        if (!this.words.isEmpty()) {
            word = this.words.removeFirst();
            this.clearAttributes();
            this.termAtt.append(word);
            this.previousWord = word;
            return true;
        }
        return false;
    }

    public void end() throws IOException {
        super.end();
        this.previousWord = null;
        this.words.clear();
    }

    public int hashCode() {
        int hash = 3;
        hash = 31 * hash + (this.termAtt != null ? this.termAtt.hashCode() : 0);
        hash = 31 * hash + (this.previousWord != null ? this.previousWord.hashCode() : 0);
        hash = 31 * hash + (this.words != null ? this.words.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        TokenPairConcatenatingFilter other = (TokenPairConcatenatingFilter)((Object)obj);
        if (!(this.termAtt == other.termAtt || this.termAtt != null && this.termAtt.equals(other.termAtt))) {
            return false;
        }
        if (this.previousWord == null ? other.previousWord != null : !this.previousWord.equals(other.previousWord)) {
            return false;
        }
        return this.words == other.words || this.words != null && this.words.equals(other.words);
    }
}

