/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.data.central.CentralSearch;
import org.owasp.dependencycheck.data.nexus.MavenArtifact;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.Evidence;
import org.owasp.dependencycheck.utils.DownloadFailedException;
import org.owasp.dependencycheck.utils.Downloader;
import org.owasp.dependencycheck.utils.FileFilterBuilder;
import org.owasp.dependencycheck.utils.InvalidSettingException;
import org.owasp.dependencycheck.utils.Settings;
import org.owasp.dependencycheck.xml.pom.PomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CentralAnalyzer
extends AbstractFileTypeAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(CentralAnalyzer.class);
    private static final String ANALYZER_NAME = "Central Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.INFORMATION_COLLECTION;
    private static final String SUPPORTED_EXTENSIONS = "jar";
    private boolean errorFlag = false;
    private CentralSearch searcher;
    private final boolean enabled = this.checkEnabled();
    private static final FileFilter FILTER = FileFilterBuilder.newInstance().addExtensions("jar").build();

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    private boolean checkEnabled() {
        boolean retval = false;
        try {
            if (Settings.getBoolean((String)"analyzer.central.enabled")) {
                if (!Settings.getBoolean((String)"analyzer.nexus.enabled") || "https://repository.sonatype.org/service/local/".equals(Settings.getString((String)"analyzer.nexus.url"))) {
                    LOGGER.debug("Enabling the Central analyzer");
                    retval = true;
                } else {
                    LOGGER.info("Nexus analyzer is enabled, disabling the Central Analyzer");
                }
            } else {
                LOGGER.info("Central analyzer disabled");
            }
        }
        catch (InvalidSettingException ise) {
            LOGGER.warn("Invalid setting. Disabling the Central analyzer");
        }
        return retval;
    }

    @Override
    public void initializeFileTypeAnalyzer() throws Exception {
        LOGGER.debug("Initializing Central analyzer");
        LOGGER.debug("Central analyzer enabled: {}", (Object)this.isEnabled());
        if (this.isEnabled()) {
            String searchUrl = Settings.getString((String)"analyzer.central.url");
            LOGGER.debug("Central Analyzer URL: {}", (Object)searchUrl);
            this.searcher = new CentralSearch(new URL(searchUrl));
        }
    }

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.central.enabled";
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    protected FileFilter getFileFilter() {
        return FILTER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void analyzeFileType(Dependency dependency, Engine engine) throws AnalysisException {
        if (this.errorFlag || !this.isEnabled()) {
            return;
        }
        try {
            List<MavenArtifact> mas = this.searcher.searchSha1(dependency.getSha1sum());
            Confidence confidence = mas.size() > 1 ? Confidence.HIGH : Confidence.HIGHEST;
            for (MavenArtifact ma : mas) {
                LOGGER.debug("Central analyzer found artifact ({}) for dependency ({})", (Object)ma, (Object)dependency.getFileName());
                dependency.addAsEvidence("central", ma, confidence);
                boolean pomAnalyzed = false;
                for (Evidence e : dependency.getVendorEvidence()) {
                    if (!"pom".equals(e.getSource())) continue;
                    pomAnalyzed = true;
                    break;
                }
                if (pomAnalyzed || ma.getPomUrl() == null) continue;
                File pomFile = null;
                try {
                    File baseDir = Settings.getTempDirectory();
                    pomFile = File.createTempFile("pom", ".xml", baseDir);
                    if (!pomFile.delete()) {
                        LOGGER.warn("Unable to fetch pom.xml for {} from Central; this could result in undetected CPE/CVEs.", (Object)dependency.getFileName());
                        LOGGER.debug("Unable to delete temp file");
                    }
                    LOGGER.debug("Downloading {}", (Object)ma.getPomUrl());
                    Downloader.fetchFile((URL)new URL(ma.getPomUrl()), (File)pomFile);
                    PomUtils.analyzePOM(dependency, pomFile);
                }
                catch (DownloadFailedException ex) {
                    LOGGER.warn("Unable to download pom.xml for {} from Central; this could result in undetected CPE/CVEs.", (Object)dependency.getFileName());
                }
                finally {
                    if (pomFile == null || FileUtils.deleteQuietly((File)pomFile)) continue;
                    pomFile.deleteOnExit();
                }
            }
        }
        catch (IllegalArgumentException iae) {
            LOGGER.info("invalid sha1-hash on {}", (Object)dependency.getFileName());
        }
        catch (FileNotFoundException fnfe) {
            LOGGER.debug("Artifact not found in repository: '{}", (Object)dependency.getFileName());
        }
        catch (IOException ioe) {
            LOGGER.debug("Could not connect to Central search", (Throwable)ioe);
            this.errorFlag = true;
        }
    }
}

