/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.url.dir.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.url.dir.internal.Configuration;
import org.ops4j.pax.url.dir.internal.FileTailImpl;
import org.ops4j.pax.url.dir.internal.Parser;
import org.ops4j.pax.url.dir.internal.bundle.BundleBuilder;
import org.ops4j.pax.url.dir.internal.bundle.ResourceWriter;

public class Connection
extends URLConnection {
    private Configuration m_config;
    private Parser m_parser;

    public Connection(URL url, Configuration config) {
        super(url);
        NullArgumentException.validateNotNull(url, "url should be provided");
        NullArgumentException.validateNotNull(config, "config should be provided");
        this.m_config = config;
        try {
            this.m_parser = new Parser(url.toExternalForm());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Given URL [" + url.getPath() + "] is invalid", e);
        }
    }

    public InputStream getInputStream() throws IOException {
        return new BundleBuilder(this.m_parser.getOptions(), new ResourceWriter(new FileTailImpl(this.m_parser.getDirectory(), this.m_parser.getTailExpr()).getParentOfTail())).build();
    }

    public void connect() throws IOException {
    }
}

