/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.scanner.file.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.net.URLUtils;
import org.ops4j.pax.scanner.MalformedSpecificationException;
import org.ops4j.pax.scanner.ProvisionSpec;
import org.ops4j.pax.scanner.ScannedBundle;
import org.ops4j.pax.scanner.Scanner;
import org.ops4j.pax.scanner.ScannerException;
import org.ops4j.pax.scanner.common.ScannedFileBundle;
import org.ops4j.pax.scanner.common.ScannerConfiguration;
import org.ops4j.pax.scanner.common.ScannerConfigurationImpl;
import org.ops4j.pax.scanner.common.SystemPropertyUtils;
import org.ops4j.util.property.PropertyResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileScanner
implements Scanner {
    private static final Log LOGGER = LogFactory.getLog(FileScanner.class);
    private static final String COMMENT_SIGN = "#";
    private static final String PROPERTY_PREFIX = "-D";
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("-D(.*)=(.*)");
    private PropertyResolver m_propertyResolver;

    public FileScanner(PropertyResolver propertyResolver) {
        NullArgumentException.validateNotNull(propertyResolver, "PropertyResolver");
        this.m_propertyResolver = propertyResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ScannedBundle> scan(ProvisionSpec provisionSpec) throws MalformedSpecificationException, ScannerException {
        NullArgumentException.validateNotNull(provisionSpec, "Provision spec");
        LOGGER.debug((Object)("Scanning [" + provisionSpec.getPath() + "]"));
        ArrayList<ScannedBundle> scannedBundles = new ArrayList<ScannedBundle>();
        ScannerConfiguration config = this.createConfiguration();
        BufferedReader bufferedReader = null;
        try {
            try {
                String line;
                bufferedReader = new BufferedReader(new InputStreamReader(URLUtils.prepareInputStream(provisionSpec.getPathAsUrl(), config.getCertificateCheck() == false)));
                Integer defaultStartLevel = this.getDefaultStartLevel(provisionSpec, config);
                Boolean defaultStart = this.getDefaultStart(provisionSpec, config);
                Boolean defaultUpdate = this.getDefaultUpdate(provisionSpec, config);
                while ((line = bufferedReader.readLine()) != null) {
                    if ("".equals(line.trim()) || line.trim().startsWith(COMMENT_SIGN)) continue;
                    if (line.trim().startsWith(PROPERTY_PREFIX)) {
                        Matcher matcher = PROPERTY_PATTERN.matcher(line.trim());
                        if (!matcher.matches() || matcher.groupCount() != 2) {
                            throw new ScannerException("Invalid property: " + line);
                        }
                        String value = matcher.group(2);
                        value = SystemPropertyUtils.resolvePlaceholders(value);
                        System.setProperty(matcher.group(1), value);
                        continue;
                    }
                    line = SystemPropertyUtils.resolvePlaceholders(line);
                    ScannedFileBundle scannedFileBundle = new ScannedFileBundle(line, defaultStartLevel, defaultStart, defaultUpdate);
                    scannedBundles.add(scannedFileBundle);
                    LOGGER.debug((Object)("Installing bundle [" + scannedFileBundle + "]"));
                }
            }
            finally {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
        }
        catch (IOException e) {
            throw new ScannerException("Could not parse the provision file", e);
        }
        return scannedBundles;
    }

    private Integer getDefaultStartLevel(ProvisionSpec provisionSpec, ScannerConfiguration config) {
        Integer startLevel = provisionSpec.getStartLevel();
        if (startLevel == null) {
            startLevel = config.getStartLevel();
        }
        return startLevel;
    }

    private Boolean getDefaultStart(ProvisionSpec provisionSpec, ScannerConfiguration config) {
        Boolean start = provisionSpec.shouldStart();
        if (start == null) {
            start = config.shouldStart();
        }
        return start;
    }

    private Boolean getDefaultUpdate(ProvisionSpec provisionSpec, ScannerConfiguration config) {
        Boolean update = provisionSpec.shouldUpdate();
        if (update == null) {
            update = config.shouldUpdate();
        }
        return update;
    }

    public void setResolver(PropertyResolver propertyResolver) {
        NullArgumentException.validateNotNull(propertyResolver, "PropertyResolver");
        this.m_propertyResolver = propertyResolver;
    }

    ScannerConfiguration createConfiguration() {
        return new ScannerConfigurationImpl(this.m_propertyResolver, "org.ops4j.pax.scanner.file");
    }
}

