/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.runner.platform;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.io.Pipe;
import org.ops4j.pax.runner.commons.Info;
import org.ops4j.pax.runner.platform.PlatformException;
import org.ops4j.pax.runner.platform.StoppableJavaRunner;
import org.ops4j.pax.runner.platform.internal.CommandLineBuilder;

public class DefaultJavaRunner
implements StoppableJavaRunner {
    private static final Log LOG = LogFactory.getLog(DefaultJavaRunner.class);
    private final boolean m_wait;
    private Process m_frameworkProcess;
    private Thread m_shutdownHook;

    public DefaultJavaRunner() {
        this(true);
    }

    public DefaultJavaRunner(boolean wait) {
        this.m_wait = wait;
    }

    public synchronized void exec(String[] vmOptions, String[] classpath, String mainClass, String[] programOptions, String javaHome, File workingDirectory) throws PlatformException {
        if (this.m_frameworkProcess != null) {
            throw new PlatformException("Platform already started");
        }
        StringBuilder cp = new StringBuilder();
        for (String path : classpath) {
            if (cp.length() != 0) {
                cp.append(File.pathSeparator);
            }
            cp.append(path);
        }
        CommandLineBuilder commandLine = new CommandLineBuilder().append(DefaultJavaRunner.getJavaExecutable(javaHome)).append(vmOptions).append("-cp").append(cp.toString()).append(mainClass).append(programOptions);
        LOG.debug((Object)("Start command line [" + Arrays.toString(commandLine.toArray()) + "]"));
        try {
            LOG.debug((Object)"Starting platform process.");
            this.m_frameworkProcess = Runtime.getRuntime().exec(commandLine.toArray(), null, workingDirectory);
        }
        catch (IOException e) {
            throw new PlatformException("Could not start up the process", e);
        }
        this.m_shutdownHook = this.createShutdownHook(this.m_frameworkProcess);
        Runtime.getRuntime().addShutdownHook(this.m_shutdownHook);
        LOG.debug((Object)"Added shutdown hook.");
        LOG.info((Object)"Runner has successfully finished his job!");
        if (this.m_wait) {
            this.waitForExit();
        } else {
            Info.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        block6: {
            try {
                if (this.m_shutdownHook == null) break block6;
                Thread thread = this.m_shutdownHook;
                synchronized (thread) {
                    if (this.m_shutdownHook != null) {
                        LOG.debug((Object)"Shutdown in progress...");
                        Runtime.getRuntime().removeShutdownHook(this.m_shutdownHook);
                        this.m_frameworkProcess = null;
                        this.m_shutdownHook.run();
                        this.m_shutdownHook = null;
                        LOG.info((Object)"Platform has been shutdown.");
                    }
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForExit() {
        Process process = this.m_frameworkProcess;
        synchronized (process) {
            try {
                LOG.debug((Object)"Waiting for framework exit.");
                Info.println();
                this.m_frameworkProcess.waitFor();
                this.shutdown();
            }
            catch (Throwable e) {
                LOG.debug((Object)"Early shutdown.", e);
                this.shutdown();
            }
        }
    }

    private Thread createShutdownHook(final Process process) {
        LOG.debug((Object)"Wrapping stream I/O.");
        final Pipe errPipe = new Pipe(process.getErrorStream(), System.err).start("Error pipe");
        final Pipe outPipe = new Pipe(process.getInputStream(), System.out).start("Out pipe");
        final Pipe inPipe = new Pipe(process.getOutputStream(), System.in).start("In pipe");
        return new Thread(new Runnable(){

            public void run() {
                Info.println();
                LOG.debug((Object)"Unwrapping stream I/O.");
                inPipe.stop();
                outPipe.stop();
                errPipe.stop();
                try {
                    process.destroy();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }, "Pax-Runner shutdown hook");
    }

    static String getJavaExecutable(String javaHome) throws PlatformException {
        if (javaHome == null) {
            throw new PlatformException("JAVA_HOME is not set.");
        }
        return javaHome + "/bin/java";
    }
}

