/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.modules;

import java.security.Principal;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.karaf.jaas.modules.Encryption;
import org.apache.karaf.jaas.modules.RolePolicy;
import org.apache.karaf.jaas.modules.encryption.EncryptionSupport;
import org.osgi.framework.BundleContext;

public abstract class AbstractKarafLoginModule
implements LoginModule {
    protected Set<Principal> principals = new HashSet<Principal>();
    protected Subject subject;
    protected String user;
    protected CallbackHandler callbackHandler;
    protected boolean debug;
    protected Map<String, ?> options;
    protected String rolePolicy;
    protected String roleDiscriminator;
    protected BundleContext bundleContext;
    private EncryptionSupport encryptionSupport;

    public boolean commit() throws LoginException {
        RolePolicy policy = RolePolicy.getPolicy(this.rolePolicy);
        if (policy != null && this.roleDiscriminator != null) {
            policy.handleRoles(this.subject, this.principals, this.roleDiscriminator);
        } else {
            this.subject.getPrincipals().addAll(this.principals);
        }
        return true;
    }

    protected void clear() {
        this.user = null;
    }

    public void initialize(Subject sub, CallbackHandler handler, Map options) {
        this.subject = sub;
        this.callbackHandler = handler;
        this.options = options;
        this.rolePolicy = (String)options.get("role.policy");
        this.roleDiscriminator = (String)options.get("role.discriminator");
        this.debug = Boolean.parseBoolean((String)options.get("debug"));
        this.bundleContext = (BundleContext)options.get(BundleContext.class.getName());
        this.encryptionSupport = new EncryptionSupport(options);
    }

    public String getEncryptedPassword(String password) {
        boolean suffix;
        Encryption encryption = this.encryptionSupport.getEncryption();
        String encryptionPrefix = this.encryptionSupport.getEncryptionPrefix();
        String encryptionSuffix = this.encryptionSupport.getEncryptionSuffix();
        if (encryption == null) {
            return password;
        }
        boolean prefix = encryptionPrefix == null || password.startsWith(encryptionPrefix);
        boolean bl = suffix = encryptionSuffix == null || password.endsWith(encryptionSuffix);
        if (prefix && suffix) {
            return password;
        }
        String p = encryption.encryptPassword(password);
        if (encryptionPrefix != null) {
            p = encryptionPrefix + p;
        }
        if (encryptionSuffix != null) {
            p = p + encryptionSuffix;
        }
        return p;
    }

    public boolean checkPassword(String plain, String encrypted) {
        boolean suffix;
        Encryption encryption = this.encryptionSupport.getEncryption();
        String encryptionPrefix = this.encryptionSupport.getEncryptionPrefix();
        String encryptionSuffix = this.encryptionSupport.getEncryptionSuffix();
        if (encryption == null) {
            return plain.equals(encrypted);
        }
        boolean prefix = encryptionPrefix == null || encrypted.startsWith(encryptionPrefix);
        boolean bl = suffix = encryptionSuffix == null || encrypted.endsWith(encryptionSuffix);
        if (prefix && suffix) {
            encrypted = encrypted.substring(encryptionPrefix != null ? encryptionPrefix.length() : 0, encrypted.length() - (encryptionSuffix != null ? encryptionSuffix.length() : 0));
            return encryption.checkPassword(plain, encrypted);
        }
        return plain.equals(encrypted);
    }
}

