/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.config.impl;

import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.aries.blueprint.ParserContext;
import org.apache.aries.blueprint.mutable.MutableBeanMetadata;
import org.apache.aries.blueprint.mutable.MutableCollectionMetadata;
import org.apache.aries.blueprint.mutable.MutableRefMetadata;
import org.apache.aries.blueprint.mutable.MutableServiceMetadata;
import org.apache.aries.blueprint.mutable.MutableValueMetadata;
import org.apache.karaf.jaas.config.JaasRealm;
import org.apache.karaf.jaas.config.KeystoreInstance;
import org.apache.karaf.jaas.config.impl.Config;
import org.apache.karaf.jaas.config.impl.Module;
import org.apache.karaf.jaas.config.impl.ResourceKeystoreInstance;
import org.osgi.service.blueprint.container.ComponentDefinitionException;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.Metadata;
import org.osgi.service.blueprint.reflect.RefMetadata;
import org.osgi.service.blueprint.reflect.ValueMetadata;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespaceHandler
implements org.apache.aries.blueprint.NamespaceHandler {
    @Override
    public URL getSchemaLocation(String namespace) {
        if ("http://karaf.apache.org/xmlns/jaas/v1.0.0".equals(namespace)) {
            return this.getClass().getResource("/org/apache/karaf/jaas/config/karaf-jaas-1.0.0.xsd");
        }
        return this.getClass().getResource("/org/apache/karaf/jaas/config/karaf-jaas-1.1.0.xsd");
    }

    @Override
    public Set<Class> getManagedClasses() {
        return new HashSet<Class>(Arrays.asList(Config.class, ResourceKeystoreInstance.class));
    }

    @Override
    public Metadata parse(Element element, ParserContext context) {
        String name;
        String string = name = element.getLocalName() != null ? element.getLocalName() : element.getNodeName();
        if ("config".equals(name)) {
            return this.parseConfig(element, context);
        }
        if ("keystore".equals(name)) {
            return this.parseKeystore(element, context);
        }
        throw new ComponentDefinitionException("Bad xml syntax: unknown element '" + name + "'");
    }

    @Override
    public ComponentMetadata decorate(Node node, ComponentMetadata component, ParserContext context) {
        throw new ComponentDefinitionException("Bad xml syntax: node decoration is not supported");
    }

    public ComponentMetadata parseConfig(Element element, ParserContext context) {
        NodeList childElements;
        MutableBeanMetadata bean = context.createMetadata(MutableBeanMetadata.class);
        bean.setRuntimeClass(Config.class);
        String name = element.getAttribute("name");
        bean.addProperty("bundleContext", this.createRef(context, "blueprintBundleContext"));
        bean.addProperty("name", this.createValue(context, name));
        String rank = element.getAttribute("rank");
        if (rank != null && rank.length() > 0) {
            bean.addProperty("rank", this.createValue(context, rank));
        }
        if ((childElements = element.getElementsByTagNameNS(element.getNamespaceURI(), "module")) != null && childElements.getLength() > 0) {
            MutableCollectionMetadata children = context.createMetadata(MutableCollectionMetadata.class);
            for (int i = 0; i < childElements.getLength(); ++i) {
                String options;
                Element childElement = (Element)childElements.item(i);
                MutableBeanMetadata md = context.createMetadata(MutableBeanMetadata.class);
                md.setRuntimeClass(Module.class);
                md.addProperty("className", this.createValue(context, childElement.getAttribute("className")));
                if (childElement.getAttribute("name") != null) {
                    md.addProperty("name", this.createValue(context, childElement.getAttribute("name")));
                }
                if (childElement.getAttribute("flags") != null) {
                    md.addProperty("flags", this.createValue(context, childElement.getAttribute("flags")));
                }
                if ((options = NamespaceHandler.getTextValue(childElement)) != null && options.length() > 0) {
                    md.addProperty("options", this.createValue(context, options));
                }
                children.addValue(md);
            }
            bean.addProperty("modules", children);
        }
        MutableServiceMetadata service = context.createMetadata(MutableServiceMetadata.class);
        service.setId(name);
        service.setServiceComponent(bean);
        service.addInterface(JaasRealm.class.getName());
        service.addServiceProperty(this.createValue(context, "org.apache.karaf.jaas.module"), this.createValue(context, name));
        return service;
    }

    public ComponentMetadata parseKeystore(Element element, ParserContext context) {
        String keyPasswords;
        String keystorePassword;
        String path;
        MutableBeanMetadata bean = context.createMetadata(MutableBeanMetadata.class);
        bean.setRuntimeClass(ResourceKeystoreInstance.class);
        String name = element.getAttribute("name");
        bean.addProperty("name", this.createValue(context, name));
        String rank = element.getAttribute("rank");
        if (rank != null && rank.length() > 0) {
            bean.addProperty("rank", this.createValue(context, rank));
        }
        if ((path = element.getAttribute("path")) != null && path.length() > 0) {
            bean.addProperty("path", this.createValue(context, path));
        }
        if ((keystorePassword = element.getAttribute("keystorePassword")) != null && keystorePassword.length() > 0) {
            bean.addProperty("keystorePassword", this.createValue(context, keystorePassword));
        }
        if ((keyPasswords = element.getAttribute("keyPasswords")) != null && keyPasswords.length() > 0) {
            bean.addProperty("keyPasswords", this.createValue(context, keyPasswords));
        }
        MutableServiceMetadata service = context.createMetadata(MutableServiceMetadata.class);
        service.setId(name);
        service.setServiceComponent(bean);
        service.addInterface(KeystoreInstance.class.getName());
        return service;
    }

    private ValueMetadata createValue(ParserContext context, String value) {
        MutableValueMetadata v = context.createMetadata(MutableValueMetadata.class);
        v.setStringValue(value);
        return v;
    }

    private RefMetadata createRef(ParserContext context, String value) {
        MutableRefMetadata r = context.createMetadata(MutableRefMetadata.class);
        r.setComponentId(value);
        return r;
    }

    private static String getTextValue(Element element) {
        StringBuffer value = new StringBuffer();
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node item = nl.item(i);
            if ((!(item instanceof CharacterData) || item instanceof Comment) && !(item instanceof EntityReference)) continue;
            value.append(item.getNodeValue());
        }
        return value.toString();
    }
}

