/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.utils;

import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicCollection<E>
extends AbstractCollection<E> {
    protected final Object lock = new Object();
    protected final List<E> storage = new ArrayList();
    protected final List<WeakReference<DynamicIterator>> iterators = new ArrayList<WeakReference<DynamicIterator>>();

    public DynamicIterator iterator() {
        return this.iterator(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicIterator iterator(int index) {
        DynamicIterator iterator = this.createIterator(index);
        Object object = this.lock;
        synchronized (object) {
            Iterator<WeakReference<DynamicIterator>> it = this.iterators.iterator();
            while (it.hasNext()) {
                if (it.next().get() != null) continue;
                it.remove();
            }
            this.iterators.add(new WeakReference<DynamicIterator>(iterator));
        }
        return iterator;
    }

    protected DynamicIterator createIterator(int index) {
        return new DynamicIterator(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this.lock;
        synchronized (object) {
            return this.storage.size();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
        Object object = this.lock;
        synchronized (object) {
            return this.storage.contains(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        Object object = this.lock;
        synchronized (object) {
            return this.storage.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        Object object = this.lock;
        synchronized (object) {
            return this.storage.toArray(a);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(Collection<?> c) {
        Object object = this.lock;
        synchronized (object) {
            return this.storage.containsAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E o) {
        if (o == null) {
            throw new NullPointerException();
        }
        Object object = this.lock;
        synchronized (object) {
            this.internalAdd(this.storage.size(), o);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
        Object object = this.lock;
        synchronized (object) {
            int index = this.storage.indexOf(o);
            return this.remove(index) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E get(int index) {
        Object object = this.lock;
        synchronized (object) {
            return this.storage.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalAdd(int index, E o) {
        if (o == null) {
            throw new NullPointerException();
        }
        Object object = this.lock;
        synchronized (object) {
            this.storage.add(index, o);
            Iterator<WeakReference<DynamicIterator>> it = this.iterators.iterator();
            while (it.hasNext()) {
                DynamicIterator i = (DynamicIterator)it.next().get();
                if (i == null) {
                    it.remove();
                    continue;
                }
                i.addedIndex(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.storage.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E remove(int index) {
        Object object = this.lock;
        synchronized (object) {
            E o = this.storage.remove(index);
            Iterator<WeakReference<DynamicIterator>> it = this.iterators.iterator();
            while (it.hasNext()) {
                WeakReference<DynamicIterator> r = it.next();
                DynamicIterator i = (DynamicIterator)r.get();
                if (i == null) {
                    it.remove();
                    continue;
                }
                i.removedIndex(index);
            }
            return o;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E first() {
        Object object = this.lock;
        synchronized (object) {
            if (this.storage.isEmpty()) {
                throw new NoSuchElementException();
            }
            return this.storage.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E last() {
        Object object = this.lock;
        synchronized (object) {
            if (this.storage.isEmpty()) {
                throw new NoSuchElementException();
            }
            return this.storage.get(this.storage.size() - 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DynamicIterator
    implements ListIterator<E> {
        protected int index;
        protected boolean hasNextCalled;
        protected E next;
        protected boolean hasPreviousCalled;
        protected E previous;
        protected E last;

        public DynamicIterator() {
            this(0);
        }

        public DynamicIterator(int index) {
            this.index = index;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void removedIndex(int index) {
            Object object = DynamicCollection.this.lock;
            synchronized (object) {
                if (index < this.index || index == this.index && (this.hasNextCalled || this.hasPreviousCalled)) {
                    --this.index;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void addedIndex(int index) {
            Object object = DynamicCollection.this.lock;
            synchronized (object) {
                if (index < this.index || index == this.index && (this.next != null || this.previous != null)) {
                    ++this.index;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            Object object = DynamicCollection.this.lock;
            synchronized (object) {
                this.hasPreviousCalled = false;
                this.hasNextCalled = true;
                this.next = this.index < DynamicCollection.this.storage.size() ? DynamicCollection.this.storage.get(this.index) : null;
                return this.next != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasPrevious() {
            Object object = DynamicCollection.this.lock;
            synchronized (object) {
                this.hasPreviousCalled = true;
                this.hasNextCalled = false;
                this.previous = this.index > 0 ? DynamicCollection.this.storage.get(this.index - 1) : null;
                return this.previous != null;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public E next() {
            Object object = DynamicCollection.this.lock;
            synchronized (object) {
                try {
                    if (!this.hasNextCalled) {
                        this.hasNext();
                    }
                    this.last = this.next;
                    if (this.next != null) {
                        ++this.index;
                        Object e = this.next;
                        return e;
                    }
                    throw new NoSuchElementException();
                }
                finally {
                    this.hasPreviousCalled = false;
                    this.hasNextCalled = false;
                    this.next = null;
                    this.previous = null;
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public E previous() {
            Object object = DynamicCollection.this.lock;
            synchronized (object) {
                try {
                    if (!this.hasPreviousCalled) {
                        this.hasPrevious();
                    }
                    this.last = this.previous;
                    if (this.previous != null) {
                        --this.index;
                        Object e = this.previous;
                        return e;
                    }
                    throw new NoSuchElementException();
                }
                finally {
                    this.hasPreviousCalled = false;
                    this.hasNextCalled = false;
                    this.next = null;
                    this.previous = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int nextIndex() {
            Object object = DynamicCollection.this.lock;
            synchronized (object) {
                return this.index;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int previousIndex() {
            Object object = DynamicCollection.this.lock;
            synchronized (object) {
                return this.index - 1;
            }
        }

        @Override
        public void set(E o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

