/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.reflect;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.aries.blueprint.mutable.MutableMapMetadata;
import org.apache.aries.blueprint.reflect.MapEntryImpl;
import org.osgi.service.blueprint.reflect.MapEntry;
import org.osgi.service.blueprint.reflect.MapMetadata;
import org.osgi.service.blueprint.reflect.Metadata;
import org.osgi.service.blueprint.reflect.NonNullMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapMetadataImpl
implements MutableMapMetadata {
    private String keyType;
    private String valueType;
    private List<MapEntry> entries;

    public MapMetadataImpl() {
    }

    public MapMetadataImpl(String keyType, String valueType, List<MapEntry> entries) {
        this.keyType = keyType;
        this.valueType = valueType;
        this.entries = entries;
    }

    public MapMetadataImpl(MapMetadata source) {
        this.valueType = source.getValueType();
        this.keyType = source.getKeyType();
        for (MapEntry entry : source.getEntries()) {
            this.addEntry(new MapEntryImpl(entry));
        }
    }

    @Override
    public String getKeyType() {
        return this.keyType;
    }

    @Override
    public void setKeyType(String keyTypeName) {
        this.keyType = keyTypeName;
    }

    @Override
    public String getValueType() {
        return this.valueType;
    }

    @Override
    public void setValueType(String valueTypeName) {
        this.valueType = valueTypeName;
    }

    @Override
    public List<MapEntry> getEntries() {
        if (this.entries == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.entries);
    }

    public void setEntries(List<MapEntry> entries) {
        this.entries = entries != null ? new ArrayList<MapEntry>(entries) : null;
    }

    @Override
    public void addEntry(MapEntry entry) {
        if (this.entries == null) {
            this.entries = new ArrayList<MapEntry>();
        }
        this.entries.add(entry);
    }

    @Override
    public MapEntry addEntry(NonNullMetadata key, Metadata value) {
        MapEntryImpl entry = new MapEntryImpl(key, value);
        this.addEntry(entry);
        return entry;
    }

    @Override
    public void removeEntry(MapEntry entry) {
        if (this.entries != null) {
            this.entries.remove(entry);
        }
    }

    public String toString() {
        return "MapMetadata[keyType='" + this.keyType + '\'' + ", valueType='" + this.valueType + '\'' + ", entries=" + this.entries + ']';
    }
}

