/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.runner.platform.internal;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.List;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.runner.platform.BundleReference;
import org.ops4j.pax.runner.platform.Configuration;
import org.ops4j.pax.runner.platform.DefaultJavaRunner;
import org.ops4j.pax.runner.platform.JavaRunner;
import org.ops4j.pax.runner.platform.LocalSystemFile;
import org.ops4j.pax.runner.platform.Platform;
import org.ops4j.pax.runner.platform.PlatformBuilder;
import org.ops4j.pax.runner.platform.PlatformContext;
import org.ops4j.pax.runner.platform.PlatformException;
import org.ops4j.pax.runner.platform.SystemFileReference;
import org.ops4j.pax.runner.platform.SystemFileReferenceBean;
import org.ops4j.pax.runner.platform.internal.AbsoluteFilePathStrategy;
import org.ops4j.pax.runner.platform.internal.CommandLineBuilder;
import org.ops4j.pax.runner.platform.internal.ConfigurationImpl;
import org.ops4j.pax.runner.platform.internal.ExecutionEnvironment;
import org.ops4j.pax.runner.platform.internal.LocalBundleReference;
import org.ops4j.pax.runner.platform.internal.LocalSystemFileImpl;
import org.ops4j.pax.runner.platform.internal.PlatformContextImpl;
import org.ops4j.pax.runner.platform.internal.PlatformDefinition;
import org.ops4j.pax.runner.platform.internal.PlatformDefinitionImpl;
import org.ops4j.pax.runner.platform.internal.RelativeFilePathStrategy;
import org.ops4j.pax.runner.platform.internal.StreamUtils;
import org.ops4j.util.property.DictionaryPropertyResolver;
import org.ops4j.util.property.PropertyResolver;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlatformImpl
implements Platform {
    private static final Log LOGGER = LogFactory.getLog(PlatformImpl.class);
    private final PlatformBuilder m_platformBuilder;
    private PropertyResolver m_propertyResolver;

    public PlatformImpl(PlatformBuilder platformBuilder) {
        NullArgumentException.validateNotNull(platformBuilder, "Platform builder");
        this.m_platformBuilder = platformBuilder;
    }

    public void setResolver(PropertyResolver propertyResolver) {
        this.m_propertyResolver = propertyResolver;
    }

    @Override
    public void start(List<SystemFileReference> systemFiles, List<BundleReference> bundles, Properties properties, Dictionary config, JavaRunner javaRunner) throws PlatformException {
        LOGGER.info((Object)("Preparing framework [" + this + "]"));
        String mainClassName = this.m_platformBuilder.getMainClassName();
        if (mainClassName == null || mainClassName.trim().length() == 0) {
            throw new PlatformException("Main class of the platform cannot be null or empty");
        }
        PlatformContext context = this.mandatory("Platform context", this.createPlatformContext());
        context.setProperties(properties);
        Configuration configuration = this.mandatory("Configuration", this.createConfiguration(config));
        context.setConfiguration(configuration);
        PlatformDefinition definition = this.mandatory("Definition", this.createPlatformDefinition(configuration));
        LOGGER.debug((Object)("Using platform definition [" + definition + "]"));
        File workDir = this.mandatory("Working dir", this.createWorkingDir(configuration.getWorkingDirectory()));
        LOGGER.debug((Object)("Using working directory [" + workDir + "]"));
        context.setWorkingDirectory(workDir);
        if (configuration.useAbsoluteFilePaths().booleanValue()) {
            context.setFilePathStrategy(new AbsoluteFilePathStrategy());
        } else {
            context.setFilePathStrategy(new RelativeFilePathStrategy(workDir));
        }
        Boolean overwriteBundles = configuration.isOverwrite();
        Boolean overwriteUserBundles = configuration.isOverwriteUserBundles();
        Boolean overwriteSystemBundles = configuration.isOverwriteSystemBundles();
        Boolean downloadFeeback = configuration.isDownloadFeedback();
        LOGGER.info((Object)"Downloading bundles...");
        LOGGER.debug((Object)"Download system package");
        File systemFile = this.downloadSystemFile(workDir, definition, overwriteBundles != false || overwriteSystemBundles != false, downloadFeeback);
        LOGGER.debug((Object)"Download additional system libraries");
        List<LocalSystemFile> localSystemFiles = this.downloadSystemFiles(workDir, systemFiles, overwriteBundles != false || overwriteSystemBundles != false, downloadFeeback);
        if (configuration.keepOriginalUrls().booleanValue()) {
            localSystemFiles.addAll(this.downloadSystemFiles(workDir, this.getUrlHandlers(), overwriteBundles != false || overwriteSystemBundles != false, downloadFeeback));
        }
        ArrayList<BundleReference> bundlesToInstall = new ArrayList<BundleReference>();
        LOGGER.debug((Object)"Download platform bundles");
        bundlesToInstall.addAll(this.downloadPlatformBundles(workDir, definition, context, overwriteBundles != false || overwriteSystemBundles != false, downloadFeeback, configuration.validateBundles(), configuration.skipInvalidBundles()));
        LOGGER.debug((Object)"Download bundles");
        bundlesToInstall.addAll(this.downloadBundles(workDir, bundles, overwriteBundles != false || overwriteUserBundles != false, downloadFeeback, configuration.isAutoWrap(), configuration.keepOriginalUrls(), configuration.validateBundles(), configuration.skipInvalidBundles()));
        context.setBundles(bundlesToInstall);
        ExecutionEnvironment ee = new ExecutionEnvironment(configuration.getExecutionEnvironment());
        context.setSystemPackages(this.createPackageList(ee.getSystemPackages(), configuration.getSystemPackages(), definition.getPackages()));
        context.setExecutionEnvironment(ee.getExecutionEnvironment());
        this.m_platformBuilder.prepare(context);
        CommandLineBuilder vmOptions = new CommandLineBuilder();
        vmOptions.append(configuration.getVMOptions());
        vmOptions.append(this.m_platformBuilder.getVMOptions(context));
        if (configuration.keepOriginalUrls().booleanValue()) {
            vmOptions.append("-Djava.protocol.handler.pkgs=org.ops4j.pax.url");
        }
        Object[] classpath = this.buildClassPath(systemFile, localSystemFiles, configuration, context);
        CommandLineBuilder programOptions = new CommandLineBuilder();
        programOptions.append(this.m_platformBuilder.getArguments(context));
        programOptions.append(this.getFrameworkOptions());
        JavaRunner runner = javaRunner;
        if (runner == null) {
            runner = new DefaultJavaRunner();
        }
        String javaHome = configuration.getJavaHome();
        LOGGER.debug((Object)("Using " + runner.getClass() + " [" + mainClassName + "]"));
        LOGGER.debug((Object)("VM options:       [" + Arrays.toString(vmOptions.toArray()) + "]"));
        LOGGER.debug((Object)("Classpath:        [" + Arrays.toString(classpath) + "]"));
        LOGGER.debug((Object)("Platform options: [" + Arrays.toString(programOptions.toArray()) + "]"));
        LOGGER.debug((Object)("Java home:        [" + javaHome + "]"));
        LOGGER.debug((Object)("Working dir:      [" + workDir + "]"));
        runner.exec(vmOptions.toArray(), (String[])classpath, mainClassName, programOptions.toArray(), javaHome, workDir);
    }

    private List<SystemFileReference> getUrlHandlers() throws PlatformException {
        ArrayList<SystemFileReference> urlHandlers = new ArrayList<SystemFileReference>();
        try {
            urlHandlers.add(new SystemFileReferenceBean("Pax URL mvn: protocol", new URL("mvn:org.ops4j.pax.url/pax-url-mvn")));
            urlHandlers.add(new SystemFileReferenceBean("Pax URL link: protocol", new URL("mvn:org.ops4j.pax.url/pax-url-link")));
            urlHandlers.add(new SystemFileReferenceBean("Pax URL war: protocol", new URL("mvn:org.ops4j.pax.url/pax-url-war")));
            urlHandlers.add(new SystemFileReferenceBean("Pax URL wrap: protocol", new URL("mvn:org.ops4j.pax.url/pax-url-wrap")));
            urlHandlers.add(new SystemFileReferenceBean("Pax URL cache: protocol", new URL("mvn:org.ops4j.pax.url/pax-url-cache")));
        }
        catch (MalformedURLException e) {
            throw new PlatformException("Cannot download url handlers", e);
        }
        return urlHandlers;
    }

    private String[] buildClassPath(File systemFile, List<LocalSystemFile> systemFiles, Configuration configuration, PlatformContext context) {
        StringBuilder prepend = new StringBuilder();
        StringBuilder append = new StringBuilder();
        for (LocalSystemFile ref : systemFiles) {
            if (ref.getSystemFileReference().shouldPrepend().booleanValue()) {
                if (prepend.length() != 0) {
                    prepend.append(File.pathSeparator);
                }
                prepend.append(context.getFilePathStrategy().normalizeAsPath(ref.getFile()));
                continue;
            }
            if (append.length() != 0) {
                append.append(File.pathSeparator);
            }
            append.append(context.getFilePathStrategy().normalizeAsPath(ref.getFile()));
        }
        if (prepend.length() != 0) {
            prepend.append(File.pathSeparator);
        }
        if (append.length() != 0) {
            append.insert(0, File.pathSeparator);
        }
        StringBuilder classPath = new StringBuilder();
        classPath.append((CharSequence)prepend);
        classPath.append(context.getFilePathStrategy().normalizeAsPath(systemFile));
        classPath.append((CharSequence)append);
        classPath.append(configuration.getClasspath());
        return classPath.toString().split(File.pathSeparator);
    }

    private String[] getFrameworkOptions() {
        String[] options = new String[]{};
        String property = System.getProperty("FRAMEWORK_OPTS");
        if (property != null) {
            options = property.split(" ");
        }
        return options;
    }

    private List<BundleReference> downloadBundles(File workDir, List<BundleReference> bundles, Boolean overwrite, boolean downloadFeeback, boolean autoWrap, boolean keepOriginalUrls, boolean validateBundles, boolean skipInvalidBundles) throws PlatformException {
        ArrayList<BundleReference> localBundles = new ArrayList<BundleReference>();
        if (bundles != null) {
            for (BundleReference reference : bundles) {
                URL url = reference.getURL();
                if (url == null) {
                    throw new PlatformException("Invalid url in bundle reference [" + reference + "]");
                }
                if (autoWrap) {
                    try {
                        String urlToWrap = url.toExternalForm();
                        if (!urlToWrap.startsWith("wrap:")) {
                            url = new URL("wrap:" + urlToWrap);
                        }
                    }
                    catch (MalformedURLException e) {
                        LOGGER.warn((Object)("Could not auto wrap url [" + url + "] due to: " + e.getMessage()));
                    }
                }
                if (keepOriginalUrls) {
                    localBundles.add(reference);
                    continue;
                }
                File bundleFile = this.download(workDir, url, reference.getName(), overwrite != false || reference.shouldUpdate() != false, validateBundles, !skipInvalidBundles, downloadFeeback);
                if (bundleFile != null) {
                    localBundles.add(new LocalBundleReference(reference, bundleFile));
                    continue;
                }
                LOGGER.info((Object)("Bundle [" + url + "] skipped from provisioning as it is invalid"));
            }
        }
        return localBundles;
    }

    private List<BundleReference> downloadPlatformBundles(File workDir, PlatformDefinition definition, PlatformContext platformContext, Boolean overwrite, boolean downloadFeeback, boolean validateBundles, boolean skipInvalidBundles) throws PlatformException {
        String builderProfile;
        StringBuilder profiles = new StringBuilder();
        String userProfiles = platformContext.getConfiguration().getProfiles();
        if (userProfiles != null && userProfiles.trim().length() > 0) {
            profiles.append(userProfiles);
        }
        if ((builderProfile = this.m_platformBuilder.getRequiredProfile(platformContext)) != null && builderProfile.trim().length() > 0) {
            if (profiles.length() > 0) {
                profiles.append(",");
            }
            profiles.append(builderProfile);
        }
        return this.downloadBundles(workDir, definition.getPlatformBundles(profiles.toString()), overwrite, downloadFeeback, false, false, validateBundles, skipInvalidBundles);
    }

    private File downloadSystemFile(File workDir, PlatformDefinition definition, Boolean overwrite, boolean downloadFeeback) throws PlatformException {
        return this.download(workDir, definition.getSystemPackage(), definition.getSystemPackageName(), overwrite, false, true, downloadFeeback);
    }

    private List<LocalSystemFile> downloadSystemFiles(File workDir, List<SystemFileReference> systemFiles, Boolean overwrite, boolean downloadFeeback) throws PlatformException {
        ArrayList<LocalSystemFile> downloaded = new ArrayList<LocalSystemFile>();
        if (systemFiles != null) {
            for (SystemFileReference reference : systemFiles) {
                downloaded.add(new LocalSystemFileImpl(reference, this.download(workDir, reference.getURL(), reference.getName(), overwrite, false, true, downloadFeeback)));
            }
        }
        return downloaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File download(File workDir, URL url, String displayName, Boolean overwrite, boolean checkAttributes, boolean failOnValidation, boolean downloadFeeback) throws PlatformException {
        String cachingName;
        boolean forceOverwrite;
        LOGGER.debug((Object)("Downloading [" + url + "]"));
        File downloadedBundlesFile = new File(workDir, "bundles/downloaded_bundles.properties");
        Properties fileNamesForUrls = this.loadProperties(downloadedBundlesFile);
        String downloadedFileName = fileNamesForUrls.getProperty(url.toExternalForm());
        String hashFileName = "" + url.toExternalForm().hashCode();
        if (downloadedFileName == null) {
            downloadedFileName = hashFileName + ".jar";
        }
        File destination = new File(workDir, "bundles/" + downloadedFileName);
        boolean bl = forceOverwrite = overwrite != false || !destination.exists();
        if (!forceOverwrite) {
            try {
                cachingName = this.determineCachingName(destination, hashFileName);
                if (!destination.getName().equals(cachingName)) {
                    throw new PlatformException("File " + destination + " should have name " + cachingName);
                }
            }
            catch (PlatformException ignore) {
                forceOverwrite = true;
            }
        }
        if (forceOverwrite) {
            try {
                LOGGER.debug((Object)("Creating new file at destination: " + destination.getAbsolutePath()));
                destination.getParentFile().mkdirs();
                destination.createNewFile();
                FilterOutputStream os = null;
                try {
                    os = new BufferedOutputStream(new FileOutputStream(destination));
                    StreamUtils.ProgressBar progressBar = null;
                    if (LOGGER.isInfoEnabled()) {
                        progressBar = downloadFeeback ? new StreamUtils.FineGrainedProgressBar(displayName) : new StreamUtils.CoarseGrainedProgressBar(displayName);
                    }
                    StreamUtils.streamCopy(url, (BufferedOutputStream)os, progressBar);
                    LOGGER.debug((Object)("Succesfully downloaded to [" + destination + "]"));
                }
                finally {
                    if (os != null) {
                        os.close();
                    }
                }
            }
            catch (IOException e) {
                throw new PlatformException("[" + url + "] could not be downloaded", e);
            }
        }
        if (checkAttributes) {
            try {
                this.validateBundle(url, destination);
            }
            catch (PlatformException e) {
                if (failOnValidation) {
                    throw e;
                }
                return null;
            }
        }
        cachingName = this.determineCachingName(destination, hashFileName);
        File newDestination = new File(destination.getParentFile(), cachingName);
        if (!cachingName.equals(destination.getName())) {
            if (newDestination.exists() && !newDestination.delete()) {
                throw new PlatformException("Cannot delete " + newDestination);
            }
            if (!destination.renameTo(newDestination)) {
                throw new PlatformException("Cannot rename " + destination + " to " + newDestination);
            }
            fileNamesForUrls.setProperty(url.toExternalForm(), cachingName);
            this.saveProperties(fileNamesForUrls, downloadedBundlesFile);
        }
        return newDestination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadProperties(File file) {
        Properties properties = new Properties();
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            properties.load(in);
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException e) {
            Properties properties3 = properties;
            return properties3;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private void saveProperties(Properties properties, File file) throws PlatformException {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            properties.store(os, "");
        }
        catch (IOException e) {
            throw new PlatformException("Cannot store properties " + file, e);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {}
            }
        }
    }

    void validateBundle(URL url, File file) throws PlatformException {
        String bundleSymbolicName = null;
        String bundleName = null;
        JarFile jar = null;
        try {
            jar = new JarFile(file, false);
            Manifest manifest = jar.getManifest();
            if (manifest == null) {
                throw new PlatformException("[" + url + "] is not a valid bundle");
            }
            bundleSymbolicName = manifest.getMainAttributes().getValue("Bundle-SymbolicName");
            bundleName = manifest.getMainAttributes().getValue("Bundle-Name");
        }
        catch (IOException e) {
            throw new PlatformException("[" + url + "] is not a valid bundle", e);
        }
        finally {
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (IOException ignore) {}
            }
        }
        if (bundleSymbolicName == null && bundleName == null) {
            throw new PlatformException("[" + url + "] is not a valid bundle");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String determineCachingName(File file, String defaultBundleSymbolicName) {
        String bundleSymbolicName = null;
        String bundleVersion = null;
        JarFile jar = null;
        try {
            jar = new JarFile(file, false);
            Manifest manifest = jar.getManifest();
            if (manifest != null) {
                bundleSymbolicName = manifest.getMainAttributes().getValue("Bundle-SymbolicName");
                bundleVersion = manifest.getMainAttributes().getValue("Bundle-Version");
            }
        }
        catch (IOException ignore) {
        }
        finally {
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (IOException ignore) {}
            }
        }
        if (bundleSymbolicName == null) {
            bundleSymbolicName = defaultBundleSymbolicName;
        } else {
            int semicolonPos = bundleSymbolicName.indexOf(";");
            if (semicolonPos > 0) {
                bundleSymbolicName = bundleSymbolicName.substring(0, semicolonPos);
            }
        }
        if (bundleVersion == null) {
            bundleVersion = "0.0.0";
        }
        return bundleSymbolicName + "_" + bundleVersion + ".jar";
    }

    private File createWorkingDir(String path) {
        File workDir = new File(path);
        workDir.mkdirs();
        return workDir;
    }

    private String createPackageList(String eePackages, String userPackages, String platformPackages) {
        StringBuilder packages = new StringBuilder();
        packages.append(eePackages);
        if (userPackages != null && userPackages.trim().length() > 0) {
            if (packages.length() > 0) {
                packages.append(",");
            }
            packages.append(userPackages);
        }
        if (platformPackages != null && platformPackages.trim().length() > 0) {
            if (packages.length() > 0) {
                packages.append(",");
            }
            packages.append(platformPackages);
        }
        return packages.toString();
    }

    Configuration createConfiguration(Dictionary config) {
        PropertyResolver propertyResolver = this.m_propertyResolver;
        if (config != null) {
            propertyResolver = new DictionaryPropertyResolver(config, this.m_propertyResolver);
        }
        return new ConfigurationImpl(propertyResolver);
    }

    PlatformDefinition createPlatformDefinition(Configuration configuration) throws PlatformException {
        NullArgumentException.validateNotNull(configuration, "Configuration");
        try {
            URL definitionURL = configuration.getDefinitionURL();
            InputStream inputStream = null;
            if (definitionURL != null) {
                LOGGER.debug((Object)("loading definition from url " + definitionURL.toExternalForm()));
                inputStream = definitionURL.openStream();
            }
            if (inputStream == null) {
                LOGGER.debug((Object)"loading definition from builder.");
                inputStream = this.m_platformBuilder.getDefinition(configuration);
            }
            return new PlatformDefinitionImpl(inputStream, configuration.getProfileStartLevel());
        }
        catch (IOException e) {
            throw new PlatformException("Invalid platform definition", e);
        }
        catch (ParserConfigurationException e) {
            throw new PlatformException("Invalid platform definition", e);
        }
        catch (SAXException e) {
            throw new PlatformException("Invalid platform definition", e);
        }
    }

    PlatformContext createPlatformContext() {
        return new PlatformContextImpl();
    }

    private <T> T mandatory(String name, T object) {
        if (object == null) {
            throw new IllegalStateException(name + " cannot be null");
        }
        return object;
    }

    public String toString() {
        return this.m_platformBuilder.toString();
    }
}

