/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.junit;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.junit.Test;
import org.junit.internal.runners.ClassRoadie;
import org.junit.internal.runners.InitializationError;
import org.junit.internal.runners.MethodValidator;
import org.junit.internal.runners.TestClass;
import org.junit.internal.runners.TestMethod;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.manipulation.Sortable;
import org.junit.runner.manipulation.Sorter;
import org.junit.runner.notification.RunNotifier;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.Info;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.OptionUtils;
import org.ops4j.pax.exam.junit.Configuration;
import org.ops4j.pax.exam.junit.ConfigurationStrategy;
import org.ops4j.pax.exam.junit.JUnit4ConfigMethod;
import org.ops4j.pax.exam.junit.JUnit4ConfigMethods;
import org.ops4j.pax.exam.junit.JUnitOptions;
import org.ops4j.pax.exam.junit.internal.JUnit4MethodRoadie;
import org.ops4j.pax.exam.junit.internal.JUnit4TestMethod;
import org.ops4j.pax.exam.junit.options.JUnitBundlesOption;
import org.ops4j.pax.exam.options.CompositeOption;
import org.ops4j.pax.exam.options.DefaultCompositeOption;
import org.ops4j.pax.exam.options.FrameworkOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnit4TestRunner
extends Runner
implements Filterable,
Sortable {
    private final List<JUnit4TestMethod> m_testMethods;
    private final TestClass m_testClass;

    public JUnit4TestRunner(Class<?> klass) throws InitializationError {
        this.m_testClass = new TestClass(klass);
        try {
            this.m_testMethods = this.getTestMethods();
        }
        catch (Exception e) {
            throw new InitializationError(new Throwable[]{e});
        }
        this.validate();
    }

    protected List<JUnit4TestMethod> getTestMethods() throws Exception {
        Collection<JUnit4ConfigMethod> configMethods = this.getConfigurationMethods();
        ArrayList<JUnit4TestMethod> methods = new ArrayList<JUnit4TestMethod>();
        List testMethods = this.m_testClass.getAnnotatedMethods(Test.class);
        for (Method testMethod : testMethods) {
            Option configOptions = JUnit4TestRunner.getOptions(testMethod, configMethods);
            FrameworkOption[] frameworkOptions = (FrameworkOption[])OptionUtils.filter(FrameworkOption.class, (Option[])new Option[]{configOptions});
            Option[] filteredOptions = OptionUtils.remove(FrameworkOption.class, (Option[])new Option[]{configOptions});
            if (frameworkOptions.length == 0) {
                methods.add(new JUnit4TestMethod(testMethod, this.m_testClass, null, filteredOptions));
                continue;
            }
            for (FrameworkOption frameworkOption : frameworkOptions) {
                methods.add(new JUnit4TestMethod(testMethod, this.m_testClass, frameworkOption, filteredOptions));
            }
        }
        return methods;
    }

    protected Collection<JUnit4ConfigMethod> getConfigurationMethods() throws Exception {
        Object testInstance = this.m_testClass.getJavaClass().newInstance();
        ConfigurationStrategy configStrategy = this.m_testClass.getJavaClass().getAnnotation(ConfigurationStrategy.class);
        if (configStrategy == null) {
            configStrategy = DefaultConfigurationStrategy.class.getAnnotation(ConfigurationStrategy.class);
        }
        Class<? extends JUnit4ConfigMethods>[] configMethodsClasses = configStrategy.value();
        ArrayList<JUnit4ConfigMethod> configMethods = new ArrayList<JUnit4ConfigMethod>();
        for (Class<? extends JUnit4ConfigMethods> configMethodsClass : configMethodsClasses) {
            Collection<? extends JUnit4ConfigMethod> methods = configMethodsClass.newInstance().getConfigMethods(this.m_testClass, testInstance);
            if (methods == null) continue;
            configMethods.addAll(methods);
        }
        Configuration profileConfiguration = this.m_testClass.getJavaClass().getAnnotation(Configuration.class);
        if (profileConfiguration != null) {
            for (final Class<? extends CompositeOption> options : profileConfiguration.extend()) {
                configMethods.add(new JUnit4ConfigMethod(){

                    public boolean matches(Method testMethod) {
                        return true;
                    }

                    public Option[] getOptions() throws Exception {
                        return ((CompositeOption)options.newInstance()).getOptions();
                    }
                });
            }
        }
        return configMethods;
    }

    protected void validate() throws InitializationError {
        MethodValidator methodValidator = new MethodValidator(this.m_testClass);
        methodValidator.assertValid();
    }

    public void run(final RunNotifier notifier) {
        new ClassRoadie(notifier, this.m_testClass, this.getDescription(), new Runnable(){

            public void run() {
                JUnit4TestRunner.this.runMethods(notifier);
            }
        }).runProtected();
    }

    protected void runMethods(RunNotifier notifier) {
        for (JUnit4TestMethod method : this.m_testMethods) {
            this.invokeTestMethod(method, notifier);
        }
    }

    public Description getDescription() {
        Description spec = Description.createSuiteDescription((String)this.getName(), (Annotation[])this.classAnnotations());
        List<JUnit4TestMethod> testMethods = this.m_testMethods;
        for (JUnit4TestMethod method : testMethods) {
            spec.addChild(this.methodDescription(method));
        }
        return spec;
    }

    protected Annotation[] classAnnotations() {
        return this.m_testClass.getJavaClass().getAnnotations();
    }

    protected String getName() {
        return this.getTestClass().getName();
    }

    protected Object createTest() throws Exception {
        return this.getTestClass().getConstructor().newInstance(new Object[0]);
    }

    protected void invokeTestMethod(JUnit4TestMethod method, RunNotifier notifier) {
        Object test;
        Description description = this.methodDescription(method);
        try {
            test = this.createTest();
        }
        catch (InvocationTargetException e) {
            notifier.testAborted(description, e.getCause());
            return;
        }
        catch (Exception e) {
            notifier.testAborted(description, (Throwable)e);
            return;
        }
        new JUnit4MethodRoadie(test, method, notifier, description).run();
    }

    protected TestMethod wrapMethod(Method method) {
        return new TestMethod(method, this.m_testClass);
    }

    protected String testName(Method method) {
        return method.getName();
    }

    protected String testName(JUnit4TestMethod method) {
        return method.getName();
    }

    protected Description methodDescription(Method method) {
        return Description.createTestDescription((Class)this.getTestClass().getJavaClass(), (String)this.testName(method), (Annotation[])this.testAnnotations(method));
    }

    protected Description methodDescription(JUnit4TestMethod method) {
        return Description.createTestDescription((Class)this.getTestClass().getJavaClass(), (String)this.testName(method), (Annotation[])this.testAnnotations(method.getTestMethod()));
    }

    protected Annotation[] testAnnotations(Method method) {
        return method.getAnnotations();
    }

    public void filter(Filter filter) throws NoTestsRemainException {
        Iterator<JUnit4TestMethod> iter = this.m_testMethods.iterator();
        while (iter.hasNext()) {
            JUnit4TestMethod method = iter.next();
            if (filter.shouldRun(this.methodDescription(method.getTestMethod()))) continue;
            iter.remove();
        }
        if (this.m_testMethods.isEmpty()) {
            throw new NoTestsRemainException();
        }
    }

    public void sort(final Sorter sorter) {
        Collections.sort(this.m_testMethods, new Comparator<JUnit4TestMethod>(){

            @Override
            public int compare(JUnit4TestMethod o1, JUnit4TestMethod o2) {
                return sorter.compare(JUnit4TestRunner.this.methodDescription(o1), JUnit4TestRunner.this.methodDescription(o2));
            }
        });
    }

    protected TestClass getTestClass() {
        return this.m_testClass;
    }

    private static Option getOptions(Method methodName, Collection<JUnit4ConfigMethod> configMethods) throws Exception {
        DefaultCompositeOption option = new DefaultCompositeOption(new Option[]{(Option)CoreOptions.mavenBundle().groupId("org.ops4j.pax.exam").artifactId("pax-exam").version(Info.getPaxExamVersion()).update(Boolean.valueOf(Info.isPaxExamSnapshotVersion())).startLevel(Integer.valueOf(1)), (Option)CoreOptions.mavenBundle().groupId("org.ops4j.pax.exam").artifactId("pax-exam-junit-extender").version(Info.getPaxExamVersion()).update(Boolean.valueOf(Info.isPaxExamSnapshotVersion())).startLevel(Integer.valueOf(1)), (Option)CoreOptions.mavenBundle().groupId("org.ops4j.pax.exam").artifactId("pax-exam-junit-extender-impl").version(Info.getPaxExamVersion()).update(Boolean.valueOf(Info.isPaxExamSnapshotVersion())).startLevel(Integer.valueOf(1))});
        for (JUnit4ConfigMethod configMethod : configMethods) {
            if (!configMethod.matches(methodName)) continue;
            option.add(configMethod.getOptions());
        }
        if (((JUnitBundlesOption[])OptionUtils.filter(JUnitBundlesOption.class, (Option[])new Option[]{option})).length == 0) {
            option.add(new Option[]{JUnitOptions.junitBundles()});
        }
        return option;
    }

    @ConfigurationStrategy
    private class DefaultConfigurationStrategy {
        private DefaultConfigurationStrategy() {
        }
    }
}

