/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.container.def.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.rmi.NoSuchObjectException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.io.FileUtils;
import org.ops4j.pax.exam.CompositeCustomizer;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.Info;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.OptionUtils;
import org.ops4j.pax.exam.container.def.PaxRunnerOptions;
import org.ops4j.pax.exam.container.def.internal.ArgumentsBuilder;
import org.ops4j.pax.exam.container.def.internal.TestContainerSemaphore;
import org.ops4j.pax.exam.container.def.options.BundleScannerProvisionOption;
import org.ops4j.pax.exam.container.def.options.RBCLookupTimeoutOption;
import org.ops4j.pax.exam.container.def.options.Scanner;
import org.ops4j.pax.exam.options.ProvisionOption;
import org.ops4j.pax.exam.options.TestContainerStartTimeoutOption;
import org.ops4j.pax.exam.options.UrlReference;
import org.ops4j.pax.exam.rbc.client.RemoteBundleContextClient;
import org.ops4j.pax.exam.spi.container.TestContainer;
import org.ops4j.pax.exam.spi.container.TestContainerException;
import org.ops4j.pax.exam.spi.container.TimeoutException;
import org.ops4j.pax.runner.Run;
import org.ops4j.pax.runner.handler.internal.URLUtils;
import org.ops4j.pax.runner.platform.DefaultJavaRunner;
import org.ops4j.pax.runner.platform.JavaRunner;
import org.ops4j.store.Handle;
import org.ops4j.store.Store;
import org.ops4j.store.StoreFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PaxRunnerTestContainer
implements TestContainer {
    private static final Log LOG = LogFactory.getLog(PaxRunnerTestContainer.class);
    private static final int AMOUNT_OF_PORTS_TO_CHECK = 100;
    private static final int SYSTEM_BUNDLE = 0;
    private final RemoteBundleContextClient m_remoteBundleContextClient;
    private final DefaultJavaRunner m_javaRunner;
    private final ArgumentsBuilder m_arguments;
    private final long m_startTimeout;
    private final Store<InputStream> m_store;
    private final Map<String, Handle> m_cache;
    private final CompositeCustomizer m_customizers;
    private TestContainerSemaphore m_semaphore;
    private boolean m_started = false;
    private Registry m_registry;

    PaxRunnerTestContainer(DefaultJavaRunner javaRunner, Option ... options) {
        this.m_javaRunner = javaRunner;
        this.m_startTimeout = PaxRunnerTestContainer.getTestContainerStartTimeout(options);
        int registryPort = this.createRegistry();
        this.m_remoteBundleContextClient = new RemoteBundleContextClient(Integer.valueOf(registryPort), PaxRunnerTestContainer.getRMITimeout(options));
        this.m_arguments = new ArgumentsBuilder(this.wrap(OptionUtils.expand((Option[])OptionUtils.combine((Option[])options, (Option[])this.localOptions()))));
        this.m_customizers = new CompositeCustomizer(this.m_arguments.getCustomizers());
        this.m_store = StoreFactory.sharedLocalStore();
        this.m_cache = new HashMap<String, Handle>();
    }

    public <T> T getService(Class<T> serviceType) {
        LOG.debug((Object)("Lookup a [" + serviceType.getName() + "]"));
        return (T)this.m_remoteBundleContextClient.getService(serviceType);
    }

    public <T> T getService(Class<T> serviceType, long timeoutInMillis) {
        LOG.debug((Object)("Lookup a [" + serviceType.getName() + "]"));
        return (T)this.m_remoteBundleContextClient.getService(serviceType, timeoutInMillis);
    }

    public long installBundle(String bundleUrl) {
        long id;
        LOG.debug((Object)("Preparing and Installing bundle [" + bundleUrl + "] .."));
        try {
            id = this.m_remoteBundleContextClient.installBundle(this.m_store.getLocation(this.storeAndGetData(bundleUrl)).toASCIIString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        LOG.debug((Object)("Installed bundle " + bundleUrl + " as ID: " + id));
        return id;
    }

    private Handle storeAndGetData(String bundleUrl) {
        try {
            Handle handle = this.m_cache.get(bundleUrl);
            if (handle == null) {
                URL url = new URL(bundleUrl);
                InputStream in = url.openStream();
                in = this.m_customizers.customizeTestProbe(in);
                handle = this.m_store.store((Object)in);
                this.m_cache.put(bundleUrl, handle);
            }
            return handle;
        }
        catch (Exception e) {
            LOG.error((Object)"problem in preparing probe. ", (Throwable)e);
            return null;
        }
    }

    public long installBundle(String bundleLocation, byte[] bundle) {
        LOG.debug((Object)("Installing bundle [" + bundleLocation + "] .."));
        long id = this.m_remoteBundleContextClient.installBundle(bundleLocation, bundle);
        LOG.debug((Object)("Installed bundle " + bundleLocation + " as ID: " + id));
        return id;
    }

    public void startBundle(long bundleId) throws TestContainerException {
        LOG.debug((Object)("Starting test bundle with ID " + bundleId));
        this.m_remoteBundleContextClient.startBundle(bundleId);
        LOG.debug((Object)("Started test bundle with ID " + bundleId));
    }

    public void setBundleStartLevel(long bundleId, int startLevel) throws TestContainerException {
        this.m_remoteBundleContextClient.setBundleStartLevel(bundleId, startLevel);
    }

    public void start() {
        LOG.info((Object)("Starting up the test container (Pax Runner " + Info.getPaxRunnerVersion() + " )"));
        this.m_semaphore = new TestContainerSemaphore(this.m_arguments.getWorkingFolder());
        if (!this.m_semaphore.acquire() && !FileUtils.delete((File)this.m_arguments.getWorkingFolder())) {
            throw new RuntimeException("There might be another instance of Pax Exam running. Have a look at " + this.m_semaphore.getLockFile().getAbsolutePath());
        }
        this.m_customizers.customizeEnvironment(this.m_arguments.getWorkingFolder());
        long startedAt = System.currentTimeMillis();
        URLUtils.resetURLStreamHandlerFactory();
        Run.start((JavaRunner)this.m_javaRunner, (String[])this.m_arguments.getArguments());
        LOG.info((Object)("Test container (Pax Runner " + Info.getPaxRunnerVersion() + ") started in " + (System.currentTimeMillis() - startedAt) + " millis"));
        LOG.info((Object)("Wait for test container to finish its initialization " + (this.m_startTimeout == Long.MAX_VALUE ? "without timing out" : "for " + this.m_startTimeout + " millis")));
        try {
            this.waitForState(0L, 32, this.m_startTimeout);
        }
        catch (TimeoutException e) {
            throw new TimeoutException("Test container did not initialize in the expected time of " + this.m_startTimeout + " millis");
        }
        this.m_started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        block7: {
            LOG.info((Object)"Shutting down the test container (Pax Runner)");
            try {
                if (!this.m_started) break block7;
                if (this.m_remoteBundleContextClient != null) {
                    this.m_remoteBundleContextClient.stop();
                }
                if (this.m_javaRunner != null) {
                    this.m_javaRunner.waitForExit();
                }
                if (this.m_registry == null) break block7;
                try {
                    UnicastRemoteObject.unexportObject(this.m_registry, true);
                }
                catch (NoSuchObjectException e) {
                    LOG.error((Object)"Problem in shutting down RMI registry. ", (Throwable)e);
                }
                System.gc();
                LOG.info((Object)"RMI registry stopped");
                this.m_registry = null;
            }
            finally {
                this.m_semaphore.release();
                this.m_started = false;
            }
        }
    }

    public void waitForState(long bundleId, int state, long timeoutInMillis) throws TimeoutException {
        this.m_remoteBundleContextClient.waitForState(bundleId, state, timeoutInMillis);
    }

    private Option[] localOptions() {
        return new Option[]{(Option)CoreOptions.mavenBundle().groupId("org.ops4j.pax.exam").artifactId("pax-exam-container-rbc").version(Info.getPaxExamVersion()).update(Boolean.valueOf(Info.isPaxExamSnapshotVersion())).startLevel(Integer.valueOf(1)), CoreOptions.systemProperty((String)"org.ops4j.pax.exam.rbc.rmi.port").value(this.m_remoteBundleContextClient.getRmiPort().toString()), CoreOptions.bootDelegationPackage((String)"sun.*")};
    }

    private Option[] wrap(Option ... options) {
        ProvisionOption[] provisionOptions;
        if (options != null && options.length > 0 && (provisionOptions = (ProvisionOption[])OptionUtils.filter(ProvisionOption.class, (Option[])options)) != null && provisionOptions.length > 0) {
            ArrayList<Object> processed = new ArrayList<Object>();
            for (ProvisionOption provisionOption : provisionOptions) {
                if (!(provisionOption instanceof Scanner)) {
                    processed.add(((BundleScannerProvisionOption)((BundleScannerProvisionOption)PaxRunnerOptions.scanBundle((UrlReference)provisionOption).start(provisionOption.shouldStart())).startLevel(provisionOption.getStartLevel())).update(provisionOption.shouldUpdate()));
                    continue;
                }
                processed.add(provisionOption);
            }
            return OptionUtils.combine((Option[])OptionUtils.remove(ProvisionOption.class, (Option[])options), (Option[])processed.toArray(new Option[processed.size()]));
        }
        return options;
    }

    private static long getRMITimeout(Option ... options) {
        RBCLookupTimeoutOption[] timeoutOptions = (RBCLookupTimeoutOption[])OptionUtils.filter(RBCLookupTimeoutOption.class, (Option[])options);
        if (timeoutOptions.length > 0) {
            return timeoutOptions[0].getTimeout();
        }
        return PaxRunnerTestContainer.getTestContainerStartTimeout(options);
    }

    private static long getTestContainerStartTimeout(Option ... options) {
        TestContainerStartTimeoutOption[] timeoutOptions = (TestContainerStartTimeoutOption[])OptionUtils.filter(TestContainerStartTimeoutOption.class, (Option[])options);
        if (timeoutOptions.length > 0) {
            return timeoutOptions[0].getTimeout();
        }
        return CoreOptions.waitForFrameworkStartup().getTimeout();
    }

    public String toString() {
        return "PaxRunnerTestContainer{}";
    }

    protected int createRegistry() {
        for (int port = 1099; port <= 1199; ++port) {
            try {
                this.m_registry = LocateRegistry.createRegistry(port);
                LOG.info((Object)("RMI registry started on port [" + port + "]"));
                return port;
            }
            catch (Exception exception) {
                continue;
            }
        }
        throw new RuntimeException("No free port in range 1099:1099100");
    }
}

