/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.construct.util;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Repository;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;
import org.ops4j.pax.construct.util.DirUtils;
import org.ops4j.pax.construct.util.PomUtils;
import org.ops4j.pax.construct.util.RoundTripXml;
import org.ops4j.pax.construct.util.StreamFactory;
import org.ops4j.pax.construct.util.Xpp3DomHelper;
import org.ops4j.pax.construct.util.XppPathQuery;

public class XppPom
implements PomUtils.Pom {
    private final File m_file;
    private Xpp3Dom m_pom;

    public XppPom(File pomFile) throws IOException {
        this.m_file = DirUtils.resolveFile(pomFile, true);
        try {
            XmlPullParser parser = RoundTripXml.createParser();
            Reader reader = StreamFactory.newXmlReader(this.m_file);
            parser.setInput(reader);
            this.m_pom = Xpp3DomBuilder.build((XmlPullParser)parser, (boolean)false);
            IOUtil.close((Reader)reader);
        }
        catch (XmlPullParserException e) {
            throw new IOException(e.getLocalizedMessage());
        }
    }

    public XppPom(File pomFile, String groupId, String artifactId) {
        this.m_file = DirUtils.resolveFile(pomFile, true);
        this.m_pom = new Xpp3Dom("project");
        this.m_pom.setAttribute("xmlns", "http://maven.apache.org/POM/4.0.0");
        this.m_pom.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.m_pom.setAttribute("xsi:schemaLocation", "http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd");
        Xpp3DomMap.putValue(this.m_pom, "modelVersion", "4.0.0");
        Xpp3DomMap.putValue(this.m_pom, "groupId", groupId);
        Xpp3DomMap.putValue(this.m_pom, "artifactId", artifactId);
        Xpp3DomMap.putValue(this.m_pom, "name", "");
        Xpp3DomMap.putValue(this.m_pom, "packaging", "pom");
        this.m_file.getParentFile().mkdirs();
    }

    public String getId() {
        return this.getGroupId() + ':' + this.getArtifactId() + ':' + this.getPackaging() + ':' + this.getVersion();
    }

    public String getParentId() {
        Xpp3Dom parent = this.m_pom.getChild("parent");
        if (null == parent) {
            return null;
        }
        Xpp3Dom groupId = parent.getChild("groupId");
        Xpp3Dom artifactId = parent.getChild("artifactId");
        Xpp3Dom version = parent.getChild("version");
        return groupId.getValue() + ':' + artifactId.getValue() + ":pom:" + version.getValue();
    }

    public String getGroupId() {
        Xpp3Dom groupId = this.m_pom.getChild("groupId");
        Xpp3Dom parent = this.m_pom.getChild("parent");
        if (null == groupId && null != parent) {
            groupId = parent.getChild("groupId");
        }
        if (null == groupId) {
            return null;
        }
        return groupId.getValue();
    }

    public String getArtifactId() {
        return this.m_pom.getChild("artifactId").getValue();
    }

    public String getVersion() {
        Xpp3Dom version = this.m_pom.getChild("version");
        Xpp3Dom parent = this.m_pom.getChild("parent");
        if (null == version && null != parent) {
            version = parent.getChild("version");
        }
        if (null == version) {
            return null;
        }
        return version.getValue();
    }

    public String getPackaging() {
        Xpp3Dom packaging = this.m_pom.getChild("packaging");
        if (null == packaging) {
            return "jar";
        }
        return packaging.getValue();
    }

    public List getModuleNames() {
        ArrayList<String> names = new ArrayList<String>();
        Xpp3Dom modules = this.m_pom.getChild("modules");
        if (null != modules) {
            Xpp3Dom[] values = modules.getChildren("module");
            for (int i = 0; i < values.length; ++i) {
                names.add(values[i].getValue());
            }
        }
        return names;
    }

    public PomUtils.Pom getContainingPom() {
        try {
            File baseDir = this.getBasedir();
            PomUtils.Pom pom = PomUtils.readPom(baseDir.getParentFile());
            if (pom.getModuleNames().contains(baseDir.getName())) {
                return pom;
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public PomUtils.Pom getModulePom(String name) {
        try {
            if (this.getModuleNames().contains(name)) {
                return PomUtils.readPom(new File(this.m_file.getParentFile(), name));
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public File getFile() {
        return this.m_file;
    }

    public File getBasedir() {
        return this.m_file.getParentFile();
    }

    public boolean isBundleProject() {
        return this.getPackaging().indexOf("bundle") >= 0;
    }

    public String getBundleSymbolicName() {
        Xpp3Dom symbolicName;
        Xpp3Dom properties = this.m_pom.getChild("properties");
        if (null != properties && null != (symbolicName = properties.getChild("bundle.symbolicName"))) {
            return symbolicName.getValue();
        }
        return null;
    }

    public void setParent(PomUtils.Pom pom, String relativePath, boolean overwrite) throws PomUtils.ExistingElementException {
        MavenProject project = new MavenProject(new Model());
        project.setGroupId(pom.getGroupId());
        project.setArtifactId(pom.getArtifactId());
        project.setVersion(pom.getVersion());
        this.setParent(project, relativePath, overwrite);
    }

    public void setParent(MavenProject project, String relativePath, boolean overwrite) throws PomUtils.ExistingElementException {
        if (this.m_pom.getChild("parent") != null && !overwrite) {
            throw new PomUtils.ExistingElementException("parent");
        }
        Xpp3DomMap parent = new Xpp3DomMap("parent");
        parent.putValue("relativePath", relativePath);
        parent.putValue("groupId", project.getGroupId());
        parent.putValue("artifactId", project.getArtifactId());
        parent.putValue("version", project.getVersion());
        Xpp3Dom newPom = new Xpp3Dom("project");
        newPom.addChild((Xpp3Dom)parent);
        this.m_pom = Xpp3DomHelper.mergeXpp3Dom(newPom, this.m_pom);
    }

    public void setGroupId(String newGroupId) {
        Xpp3Dom groupId = this.m_pom.getChild("groupId");
        if (null == groupId) {
            groupId = new Xpp3Dom("groupId");
            this.m_pom.addChild(groupId);
        }
        groupId.setValue(newGroupId);
    }

    public void setVersion(String newVersion) {
        Xpp3Dom version = this.m_pom.getChild("version");
        if (null == version) {
            version = new Xpp3Dom("version");
            this.m_pom.addChild(version);
        }
        version.setValue(newVersion);
    }

    public void addRepository(Repository repository, boolean snapshots, boolean releases, boolean overwrite, boolean pluginRepo) throws PomUtils.ExistingElementException {
        String elemName;
        String listName;
        if (pluginRepo) {
            listName = "pluginRepositories";
            elemName = "pluginRepository";
        } else {
            listName = "repositories";
            elemName = "repository";
        }
        String id = repository.getId();
        String url = repository.getUrl();
        String xpath = listName + '/' + elemName + "[id='" + id + "' or url='" + url + "']";
        if (this.findChildren(xpath, overwrite) && !overwrite) {
            throw new PomUtils.ExistingElementException(elemName);
        }
        Xpp3DomMap repo = new Xpp3DomMap(elemName);
        repo.putValue("id", id);
        repo.putValue("url", url);
        if (!snapshots) {
            Xpp3DomMap snapshotFlag = new Xpp3DomMap("snapshots");
            snapshotFlag.putValue("enabled", "false");
            repo.addChild(snapshotFlag);
        }
        if (!releases) {
            Xpp3DomMap releaseFlag = new Xpp3DomMap("releases");
            releaseFlag.putValue("enabled", "false");
            repo.addChild(releaseFlag);
        }
        Xpp3DomList list = new Xpp3DomList(listName);
        list.addChild(repo);
        Xpp3Dom newPom = new Xpp3Dom("project");
        newPom.addChild((Xpp3Dom)list);
        Xpp3DomHelper.mergeXpp3Dom(this.m_pom, newPom);
    }

    public void addModule(String module, boolean overwrite) throws PomUtils.ExistingElementException {
        String xpath = "modules/module[.='" + module + "']";
        if (this.findChildren(xpath, overwrite) && !overwrite) {
            throw new PomUtils.ExistingElementException("module");
        }
        Xpp3Dom mod = new Xpp3Dom("module");
        mod.setValue(module);
        Xpp3DomList list = new Xpp3DomList("modules");
        list.addChild(mod);
        Xpp3Dom newPom = new Xpp3Dom("project");
        newPom.addChild((Xpp3Dom)list);
        Xpp3DomHelper.mergeXpp3Dom(this.m_pom, newPom);
    }

    public boolean removeModule(String module) {
        String xpath = "modules/module[.='" + module + "']";
        return this.findChildren(xpath, true);
    }

    public void addDependency(Dependency dependency, boolean overwrite) throws PomUtils.ExistingElementException {
        String groupId = dependency.getGroupId();
        String artifactId = dependency.getArtifactId();
        String xpath = "dependencies/dependency[groupId='" + groupId + "' and artifactId='" + artifactId + "']";
        if (this.findChildren(xpath, overwrite) && !overwrite) {
            throw new PomUtils.ExistingElementException("dependency");
        }
        Xpp3DomMap dep = new Xpp3DomMap("dependency");
        dep.putValue("groupId", groupId);
        dep.putValue("artifactId", artifactId);
        dep.putValue("version", dependency.getVersion());
        dep.putValue("scope", dependency.getScope());
        String type = dependency.getType();
        if (!"jar".equals(type)) {
            dep.putValue("type", type);
        }
        if (dependency.isOptional()) {
            dep.putValue("optional", "true");
        }
        Xpp3DomList list = new Xpp3DomList("dependencies");
        list.addChild(dep);
        Xpp3Dom newPom = new Xpp3Dom("project");
        newPom.addChild((Xpp3Dom)list);
        Xpp3DomHelper.mergeXpp3Dom(this.m_pom, newPom);
    }

    public boolean updateDependencyGroup(Dependency dependency, String newGroupId) {
        String groupId = dependency.getGroupId();
        String artifactId = dependency.getArtifactId();
        boolean updated = false;
        String xpath1 = "dependencies/dependency[groupId='" + groupId + "' and artifactId='" + artifactId + "']";
        updated = this.updateGroupId(xpath1, newGroupId) || updated;
        String xpath2 = "dependencyManagement/" + xpath1;
        updated = this.updateGroupId(xpath2, newGroupId) || updated;
        return updated;
    }

    private boolean updateGroupId(String xpath, String newGroupId) {
        XppPathQuery pathQuery = new XppPathQuery(xpath);
        Xpp3Dom parent = pathQuery.queryParent(this.m_pom);
        if (null == parent) {
            return false;
        }
        int[] children = pathQuery.queryChildren(parent);
        for (int i = 0; i < children.length; ++i) {
            Xpp3Dom group = parent.getChild(children[i]).getChild("groupId");
            if (null == group) continue;
            group.setValue(newGroupId);
        }
        return children.length > 0;
    }

    private boolean updateVersion(String xpath, String newVersion) {
        XppPathQuery pathQuery = new XppPathQuery(xpath);
        Xpp3Dom parent = pathQuery.queryParent(this.m_pom);
        if (null == parent) {
            return false;
        }
        int[] children = pathQuery.queryChildren(parent);
        for (int i = 0; i < children.length; ++i) {
            Xpp3Dom fragment = parent.getChild(children[i]);
            Xpp3Dom version = fragment.getChild("version");
            if (null == version) {
                version = new Xpp3Dom("version");
                Xpp3DomList.addChild(fragment, 2, version);
            }
            version.setValue(newVersion);
        }
        return children.length > 0;
    }

    public boolean removeDependency(Dependency dependency) {
        String groupId = dependency.getGroupId();
        String artifactId = dependency.getArtifactId();
        boolean updated = false;
        String xpath1 = "dependencies/dependency[groupId='" + groupId + "' and artifactId='" + artifactId + "']";
        updated = this.findChildren(xpath1, true) || updated;
        String xpath2 = "dependencyManagement/" + xpath1;
        updated = this.findChildren(xpath2, true) || updated;
        return updated;
    }

    public void addExclusion(String groupId, String artifactId, boolean overwrite) throws PomUtils.ExistingElementException {
        Xpp3Dom dependencies = this.m_pom.getChild("dependencies");
        if (null == dependencies || dependencies.getChildCount() <= 0) {
            return;
        }
        String exclusionPath = "dependencies/dependency/exclusions/exclusion";
        String xpath = exclusionPath + "[groupId='" + groupId + "' and artifactId='" + artifactId + "']";
        if (this.findChildren(xpath, overwrite) && !overwrite) {
            throw new PomUtils.ExistingElementException("exclusion");
        }
        Xpp3DomMap exclude = new Xpp3DomMap("exclusion");
        exclude.putValue("groupId", groupId);
        exclude.putValue("artifactId", artifactId);
        Xpp3DomList list = new Xpp3DomList("exclusions");
        list.addChild(exclude);
        Xpp3Dom newDependency = new Xpp3Dom("dependency");
        newDependency.addChild((Xpp3Dom)list);
        Xpp3DomHelper.mergeXpp3Dom(dependencies.getChild(0), newDependency);
    }

    public boolean removeExclusion(String groupId, String artifactId) {
        boolean updated = false;
        String exclusionPath = "dependencies/dependency/exclusions/exclusion";
        String xpath1 = exclusionPath + "[groupId='" + groupId + "' and artifactId='" + artifactId + "']";
        updated = this.findChildren(xpath1, true) || updated;
        String xpath2 = "dependencyManagement/" + xpath1;
        updated = this.findChildren(xpath2, true) || updated;
        return updated;
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        Xpp3Dom map = this.m_pom.getChild("properties");
        if (null != map) {
            Xpp3Dom[] entries = map.getChildren();
            for (int i = 0; i < entries.length; ++i) {
                properties.setProperty(entries[i].getName(), entries[i].getValue());
            }
        }
        return properties;
    }

    public void setProperty(String key, String value) {
        Xpp3Dom map = this.m_pom.getChild("properties");
        if (null == map) {
            map = new Xpp3Dom("properties");
            this.m_pom.addChild(map);
        }
        Xpp3Dom entry = new Xpp3Dom(key);
        entry.setValue(value);
        map.addChild(entry);
    }

    public boolean updatePluginVersion(String groupId, String artifactId, String newVersion) {
        boolean updated = false;
        String plugins = "plugins/plugin[groupId='" + groupId + "' and artifactId='" + artifactId + "']";
        updated = this.updateVersion("build/" + plugins, newVersion) || updated;
        updated = this.updateVersion("build/pluginManagement/" + plugins, newVersion) || updated;
        return updated;
    }

    public void mergeSection(PomUtils.Pom pom, String fromSection, String toSection, boolean append) {
        if (!(pom instanceof XppPom)) {
            throw new IllegalArgumentException("Unable to merge POM type " + pom.getClass());
        }
        this.mergeSection(((XppPom)pom).m_pom, fromSection, toSection, append);
    }

    private void mergeSection(Xpp3Dom from, String fromSection, String toSection, boolean append) {
        Xpp3Dom project;
        String[] fromPath = fromSection.split("/");
        Xpp3Dom source = from;
        for (int i = 0; i < fromPath.length; ++i) {
            if (null != (source = source.getChild(fromPath[i]))) continue;
            return;
        }
        if (append) {
            Xpp3DomList.makeIntoList(source);
        }
        Xpp3Dom skeleton = project = new Xpp3Dom("project");
        if (toSection != null) {
            String[] toPath = toSection.split("/");
            for (int i = 0; i < toPath.length; ++i) {
                Xpp3Dom temp = new Xpp3Dom(toPath[i]);
                skeleton.addChild(temp);
                skeleton = temp;
            }
        }
        skeleton.addChild(source);
        this.m_pom = Xpp3DomHelper.mergeXpp3Dom(this.m_pom, project);
    }

    public void overlayDetails(PomUtils.Pom pom) {
        if (!(pom instanceof XppPom)) {
            throw new IllegalArgumentException("Unable to overlay POM type " + pom.getClass());
        }
        Xpp3Dom overlay = ((XppPom)pom).m_pom;
        Xpp3Dom project = new Xpp3Dom("project");
        List newModules = pom.getModuleNames();
        XppPom.removeProtectedElements(overlay);
        Xpp3Dom[] sections = this.m_pom.getChildren();
        for (int i = 0; i < sections.length; ++i) {
            if (null != overlay.getChild(sections[i].getName())) continue;
            project.addChild(sections[i]);
        }
        Xpp3Dom originalPom = new Xpp3Dom(this.m_pom);
        this.m_pom = Xpp3DomHelper.mergeXpp3Dom(project, overlay);
        String plugins = "plugins/plugin[artifactId='maven-bundle-plugin' or artifactId='maven-pax-plugin']";
        this.findChildren("build/" + plugins, true);
        this.mergeSection(originalPom, "build/plugins", "build", true);
        this.findChildren("build/pluginManagement/" + plugins, true);
        this.mergeSection(originalPom, "build/pluginManagement/plugins", "build/pluginManagement", true);
        this.mergeSection(originalPom, "properties", null, false);
        Iterator i = newModules.iterator();
        while (i.hasNext()) {
            String module = (String)i.next();
            if (!new File(this.getBasedir(), module).exists()) continue;
            this.addModule(module, true);
        }
    }

    private static void removeProtectedElements(Xpp3Dom fragment) {
        List<String> protectedElements = Arrays.asList("modelVersion", "parent", "artifactId", "groupId", "version", "packaging", "modules");
        Xpp3Dom[] elements = fragment.getChildren();
        for (int i = elements.length - 1; i >= 0; --i) {
            if (!protectedElements.contains(elements[i].getName())) continue;
            fragment.removeChild(i);
        }
    }

    public void write() throws IOException {
        String encoding = StreamFactory.getXmlEncoding(this.m_file);
        Writer writer = StreamFactory.newXmlWriter(this.m_file);
        XmlSerializer serializer = RoundTripXml.createSerializer();
        serializer.setOutput(writer);
        serializer.startDocument(encoding, null);
        this.m_pom.writeToSerializer(null, serializer);
        serializer.endDocument();
        IOUtil.close((Writer)writer);
    }

    private boolean findChildren(String xpath, boolean clear) {
        XppPathQuery pathQuery = new XppPathQuery(xpath);
        Xpp3Dom parent = pathQuery.queryParent(this.m_pom);
        if (null == parent) {
            return false;
        }
        int[] children = pathQuery.queryChildren(parent);
        if (clear) {
            Arrays.sort(children);
            for (int i = children.length - 1; i >= 0; --i) {
                parent.removeChild(children[i]);
            }
        }
        return children.length > 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof XppPom) {
            return this.getId().equals(((XppPom)obj).getId());
        }
        return false;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        return this.getId();
    }

    private static class Xpp3DomList
    extends Xpp3Dom {
        public Xpp3DomList(String elementName) {
            super(elementName);
            Xpp3DomList.makeIntoList(this);
        }

        public static void makeIntoList(Xpp3Dom fragment) {
            fragment.setAttribute("combine.children", "append");
        }

        public static void addChild(Xpp3Dom parent, int index, Xpp3Dom child) {
            int count = parent.getChildCount();
            parent.addChild(child);
            for (int i = index; i < count; ++i) {
                Xpp3Dom temp = parent.getChild(index);
                parent.removeChild(index);
                parent.addChild(temp);
            }
        }
    }

    private static class Xpp3DomMap
    extends Xpp3Dom {
        public Xpp3DomMap(String elementName) {
            super(elementName);
        }

        public void putValue(String elementName, String elementValue) {
            Xpp3DomMap.putValue(this, elementName, elementValue);
        }

        static void putValue(Xpp3Dom map, String name, String value) {
            if (null != value) {
                Xpp3Dom child = new Xpp3Dom(name);
                child.setValue(value);
                map.addChild(child);
            }
        }
    }
}

