/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.construct.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.ops4j.pax.construct.util.PomIterator;
import org.ops4j.pax.construct.util.PomUtils;

public final class DirUtils {
    private DirUtils() {
    }

    public static File resolveFile(File file, boolean ignoreErrors) {
        File candidate;
        block3: {
            candidate = file;
            if (null == file) {
                candidate = new File(".");
            }
            try {
                candidate = candidate.getCanonicalFile();
            }
            catch (IOException e) {
                if (ignoreErrors) break block3;
                throw new RuntimeException(e);
            }
        }
        return candidate;
    }

    public static PomUtils.Pom findPom(File baseDir, String pomId) {
        String artifactId;
        String groupId;
        if (PomUtils.isEmpty(pomId)) {
            return null;
        }
        String[] fields = pomId.split(":");
        if (fields.length > 1) {
            groupId = fields[0];
            artifactId = fields[1];
        } else {
            groupId = null;
            artifactId = pomId;
        }
        PomIterator i = new PomIterator(baseDir);
        while (i.hasNext()) {
            PomUtils.Pom pom = (PomUtils.Pom)i.next();
            if (!DirUtils.sameProject(pom, groupId, artifactId)) continue;
            return pom;
        }
        return null;
    }

    private static boolean sameProject(PomUtils.Pom pom, String groupId, String artifactId) {
        return !(!artifactId.equals(pom.getArtifactId()) && !artifactId.equals(pom.getBundleSymbolicName()) || null != groupId && !groupId.equals(pom.getGroupId()));
    }

    public static PomUtils.Pom createModuleTree(File baseDir, File targetDir) throws IOException {
        File pomFile = new File(targetDir, "pom.xml");
        if (pomFile.exists()) {
            return PomUtils.readPom(pomFile);
        }
        String[] pivot = DirUtils.calculateRelativePath(baseDir, targetDir);
        if (null == pivot) {
            return null;
        }
        File commonDir = new File(pivot[1]);
        String descentPath = pivot[2];
        PomUtils.Pom parentPom = null;
        PomUtils.Pom childPom = null;
        int i = 0;
        int j = -1;
        do {
            String pathSoFar;
            if ((pomFile = new File(commonDir, (pathSoFar = descentPath.substring(0, j + 1)) + "pom.xml")).exists()) {
                childPom = PomUtils.readPom(pomFile);
            } else if (parentPom != null && "pom".equals(parentPom.getPackaging())) {
                String module = descentPath.substring(i, j);
                childPom = DirUtils.createMissingModulePom(parentPom, module, pomFile);
            } else {
                return null;
            }
            parentPom = childPom;
        } while ((j = descentPath.indexOf(47, i = j + 1)) >= 0);
        return childPom;
    }

    private static PomUtils.Pom createMissingModulePom(PomUtils.Pom parentPom, String module, File pomFile) throws IOException {
        parentPom.addModule(module, true);
        parentPom.write();
        String groupId = PomUtils.getCompoundId(parentPom.getGroupId(), parentPom.getArtifactId());
        if (groupId.equals(parentPom.getGroupId())) {
            groupId = groupId + '.' + module;
        }
        PomUtils.Pom childPom = PomUtils.createModulePom(pomFile, groupId, module);
        childPom.setParent(parentPom, null, true);
        childPom.write();
        return childPom;
    }

    public static String[] calculateRelativePath(File baseDir, File targetDir) {
        File from = DirUtils.resolveFile(baseDir, true);
        File to = DirUtils.resolveFile(targetDir, true);
        StringBuffer dottedPath = new StringBuffer();
        StringBuffer descentPath = new StringBuffer();
        while (!from.equals(to)) {
            if (from.getPath().length() < to.getPath().length()) {
                descentPath.insert(0, to.getName() + '/');
                to = to.getParentFile();
            } else {
                dottedPath.append("../");
                from = from.getParentFile();
            }
            if (null != from && null != to) continue;
            return null;
        }
        return new String[]{dottedPath.toString(), to.getPath(), descentPath.toString()};
    }

    public static String updateLogicalParent(File pomFile, String parentId) throws IOException {
        PomUtils.Pom pom = PomUtils.readPom(pomFile);
        File baseDir = pom.getBasedir();
        PomUtils.Pom parentPom = DirUtils.findPom(baseDir, parentId);
        if (null == parentPom) {
            return null;
        }
        String[] pivot = DirUtils.calculateRelativePath(baseDir, parentPom.getBasedir());
        if (null == pivot) {
            return null;
        }
        String relativePath = pivot[0] + pivot[2];
        pom.setParent(parentPom, relativePath, true);
        pom.write();
        return relativePath;
    }

    public static String rebasePaths(String path, String baseDir, char pathSeparator) {
        if (null == path) {
            return baseDir;
        }
        String[] entries = path.split(Character.toString(pathSeparator));
        StringBuffer rebasedPath = new StringBuffer();
        for (int i = 0; i < entries.length; ++i) {
            String pathEntry = entries[i].trim();
            if (i > 0) {
                rebasedPath.append(pathSeparator);
            }
            rebasedPath.append(baseDir);
            if (".".equals(pathEntry)) continue;
            rebasedPath.append('/');
            rebasedPath.append(pathEntry);
        }
        return rebasedPath.toString();
    }

    public static List expandOSGiClassPath(File outputDir, List path, File tempDir) {
        ArrayList<String> expandedPath = new ArrayList<String>();
        Iterator i = path.iterator();
        while (i.hasNext()) {
            File element = new File((String)i.next());
            if (element.equals(outputDir)) {
                expandedPath.add(element.getPath());
                continue;
            }
            expandedPath.addAll(DirUtils.expandBundleClassPath(element, tempDir));
        }
        return expandedPath;
    }

    private static List expandBundleClassPath(File element, File tempDir) {
        File bundle = DirUtils.locateBundle(element);
        if (bundle != null && bundle.isFile()) {
            String bundleClassPath = DirUtils.extractBundleClassPath(bundle);
            File unpackDir = new File(tempDir, bundle.getName());
            return DirUtils.unpackEmbeddedEntries(bundle, unpackDir, bundleClassPath);
        }
        return Collections.singletonList(element.getPath());
    }

    private static File locateBundle(File classpathElement) {
        String outputDir = "target" + File.separator + "classes";
        String path = classpathElement.getPath();
        if (path.endsWith(outputDir)) {
            File projectDir = new File(path.substring(0, path.length() - outputDir.length()));
            try {
                PomUtils.Pom reactorPom = PomUtils.readPom(projectDir);
                String artifactId = reactorPom.getArtifactId();
                String version = reactorPom.getVersion();
                return new File(projectDir, "target/" + artifactId + '-' + version + ".jar");
            }
            catch (IOException e) {
                return null;
            }
        }
        return classpathElement;
    }

    private static String extractBundleClassPath(File bundle) {
        String bundleClassPath = null;
        try {
            Manifest manifest = new JarFile(bundle).getManifest();
            if (null != manifest) {
                Attributes mainAttributes = manifest.getMainAttributes();
                bundleClassPath = mainAttributes.getValue("Bundle-ClassPath");
            }
        }
        catch (IOException e) {
            System.err.println("WARNING: unable to read jarfile " + bundle);
        }
        if (bundleClassPath != null) {
            return bundleClassPath;
        }
        return ".";
    }

    public static boolean unpackBundle(File bundle, File here, EntryFilter filter) {
        try {
            FileUtils.deleteDirectory((File)here);
            DirUtils.unpack(bundle, here, filter);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unpack(File bundle, File here, EntryFilter filter) throws IOException {
        ZipFile zipFile = new ZipFile(bundle);
        try {
            Enumeration<? extends ZipEntry> e = zipFile.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                String name = entry.getName();
                if (entry.isDirectory() || null != filter && !filter.accept(name)) continue;
                File file = FileUtils.resolveFile((File)here, (String)name);
                file.getParentFile().mkdirs();
                InputStream in = zipFile.getInputStream(entry);
                FileOutputStream out = new FileOutputStream(file);
                try {
                    IOUtil.copy((InputStream)in, (OutputStream)out);
                }
                finally {
                    IOUtil.close((OutputStream)out);
                    IOUtil.close((InputStream)in);
                }
            }
        }
        finally {
            zipFile.close();
        }
    }

    private static List unpackEmbeddedEntries(File bundle, File here, String bundleClassPath) {
        try {
            FileUtils.deleteDirectory((File)here);
        }
        catch (IOException e) {
            return Collections.singletonList(bundle.getPath());
        }
        ArrayList<String> pathList = new ArrayList<String>();
        String pathPrefix = here.getPath();
        String[] entries = bundleClassPath.split(",");
        for (int i = 0; i < entries.length; ++i) {
            final String path = entries[i].trim();
            if (path.length() == 0) continue;
            if (".".equals(path)) {
                pathList.add(bundle.getPath());
                continue;
            }
            try {
                DirUtils.unpack(bundle, here, new EntryFilter(){

                    public boolean accept(String entryName) {
                        return entryName.startsWith(path);
                    }
                });
                pathList.add(pathPrefix + '/' + path);
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return pathList;
    }

    public static void pruneEmptyFolders(File baseDir) {
        ArrayList<File> candidates = new ArrayList<File>();
        candidates.add(baseDir);
        ArrayList<File> prunable = new ArrayList<File>();
        while (!candidates.isEmpty()) {
            File f = (File)candidates.remove(0);
            if (!f.isDirectory()) continue;
            File[] files = f.listFiles();
            candidates.addAll(Arrays.asList(files));
            prunable.add(f);
        }
        Collections.reverse(prunable);
        Iterator i = prunable.iterator();
        while (i.hasNext()) {
            File directory = (File)i.next();
            directory.delete();
        }
    }

    public static interface EntryFilter {
        public boolean accept(String var1);
    }
}

