/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.construct.project;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.ops4j.pax.construct.util.PomUtils;

public class UpdateMojo
extends AbstractMojo {
    private ArtifactFactory m_factory;
    private ArtifactResolver m_resolver;
    private ArtifactMetadataSource m_source;
    private List m_remoteRepos;
    private ArtifactRepository m_localRepo;
    private File targetDirectory;
    private String version;

    public void execute() throws MojoExecutionException {
        String groupId = "org.ops4j.pax.construct";
        Artifact scripts = this.m_factory.createBuildArtifact(groupId, "scripts", this.version, "zip");
        if (PomUtils.needReleaseVersion(this.version)) {
            this.version = PomUtils.getReleaseVersion(scripts, this.m_source, this.m_remoteRepos, this.m_localRepo, null);
            scripts.selectVersion(this.version);
        }
        if (new File(this.targetDirectory, "pax-bootstrap-pom.xml").exists()) {
            this.updatePaxConstructScripts(scripts);
        } else if (new File(this.targetDirectory, "pom.xml").exists()) {
            this.updatePaxConstructProject();
        } else {
            this.getLog().warn((CharSequence)"pax-update should be run from the scripts directory, or from a Pax-Construct project");
        }
    }

    private void updatePaxConstructScripts(Artifact scripts) throws MojoExecutionException {
        if (!PomUtils.downloadFile(scripts, this.m_resolver, this.m_remoteRepos, this.m_localRepo)) {
            throw new MojoExecutionException("Unable to download scripts " + scripts);
        }
        this.getLog().info((CharSequence)("Updating scripts to version " + this.version));
        try {
            ZipFile zip = new ZipFile(scripts.getFile());
            Enumeration<? extends ZipEntry> i = zip.entries();
            while (i.hasMoreElements()) {
                ZipEntry entry = i.nextElement();
                String name = new File(entry.getName()).getName();
                String path = new File(this.targetDirectory, name).getPath();
                if (entry.isDirectory()) continue;
                InputStream in = zip.getInputStream(entry);
                String data = IOUtil.toString((InputStream)in);
                FileUtils.fileWrite((String)path, (String)data);
                this.getLog().info((CharSequence)(" => " + path));
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Problem updating local scripts", (Exception)e);
        }
    }

    private void updatePaxConstructProject() throws MojoExecutionException {
        try {
            PomUtils.Pom pom = PomUtils.readPom(this.targetDirectory);
            boolean foundPlugin = pom.updatePluginVersion("org.ops4j", "maven-pax-plugin", this.version);
            if (foundPlugin) {
                this.getLog().info((CharSequence)("Updating Pax-Construct project to version " + this.version));
                pom.write();
                this.getLog().info((CharSequence)(" => " + pom.getFile()));
            } else {
                this.getLog().warn((CharSequence)"Unable to find reference to org.ops4j:maven-pax-plugin");
                this.getLog().warn((CharSequence)"you may need to convert this project using 'pax-clone'");
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Problem reading Maven POM: " + this.targetDirectory);
        }
    }
}

