/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.construct.project;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.ops4j.pax.construct.util.DirUtils;
import org.ops4j.pax.construct.util.PomUtils;

public class CreateModuleMojo
extends AbstractMojo {
    private String groupId;
    private String artifactId;
    private String version;
    private File targetDirectory;

    public void execute() throws MojoExecutionException {
        try {
            File modulePath = new File(this.targetDirectory, this.artifactId);
            if (new File(modulePath, "pom.xml").exists()) {
                this.getLog().warn((CharSequence)("Module " + modulePath + " already exists"));
                return;
            }
            PomUtils.Pom modulePom = DirUtils.createModuleTree(this.targetDirectory, modulePath);
            if (null == modulePom) {
                throw new MojoExecutionException("module path is outside of this project");
            }
            if (PomUtils.isNotEmpty(this.groupId)) {
                modulePom.setGroupId(this.groupId);
            }
            if (PomUtils.isNotEmpty(this.version)) {
                modulePom.setVersion(this.version);
            }
            modulePom.write();
            this.getLog().info((CharSequence)("Created new module " + modulePath));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to create module tree", (Exception)e);
        }
    }
}

