/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.construct.lifecycle;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.ops4j.pax.construct.util.CacheUtils;
import org.ops4j.pax.construct.util.PomUtils;

public class SqueakyCleanMojo
extends AbstractMojo {
    private File m_basedir;
    private MavenProject m_project;

    public void execute() throws MojoExecutionException {
        if (!PomUtils.isBundleProject(this.m_project)) {
            return;
        }
        this.getLog().info((CharSequence)"[caching meta-data]");
        CacheUtils.pushFile(this, "MANIFEST.MF", new File(this.m_basedir, "META-INF/MANIFEST.MF"));
        CacheUtils.pushFile(this, ".project", new File(this.m_basedir, ".project"));
        CacheUtils.pushFile(this, ".classpath", new File(this.m_basedir, ".classpath"));
        this.getPluginContext().put("basedir", this.m_basedir.getPath());
        FileSet generatedPaxFiles = new FileSet();
        generatedPaxFiles.setDirectory(this.m_basedir.getPath());
        generatedPaxFiles.setUseDefaultExcludes(true);
        generatedPaxFiles.setFollowSymlinks(true);
        generatedPaxFiles.addInclude("META-INF/");
        generatedPaxFiles.addInclude("OSGI-INF/");
        generatedPaxFiles.addInclude(".project");
        generatedPaxFiles.addInclude(".classpath");
        try {
            new FileSetManager(this.getLog(), false).delete(generatedPaxFiles);
        }
        catch (IOException e) {
            throw new MojoExecutionException("I/O error while deleting files", (Exception)e);
        }
    }

    protected static void recoverMetaData(AbstractMojo mojo) {
        mojo.getLog().info((CharSequence)"[recovering meta-data]");
        String basedir = (String)mojo.getPluginContext().get("basedir");
        CacheUtils.pullFile(mojo, "MANIFEST.MF", new File(basedir, "META-INF/MANIFEST.MF"));
        CacheUtils.pullFile(mojo, ".project", new File(basedir, ".project"));
        CacheUtils.pullFile(mojo, ".classpath", new File(basedir, ".classpath"));
    }
}

